% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_consecutive.R
\name{replace_consecutive}
\alias{replace_consecutive}
\title{Replaces consecutive elements}
\usage{
replace_consecutive(x, by = "", fun_for_identical = base::identical)
}
\arguments{
\item{x}{A character or factor.}

\item{by}{A character with length 1.}

\item{fun_for_identical}{A function with two arguments called \code{x} and \code{y}.}
}
\value{
A character, same length as \code{x}, now with consecutives replaced by \code{by}.
If \code{length(x) < 2}, x is returned unchanged.
}
\description{
If \code{x[i+1]=x[i]} then \code{x[i+1]} is replaced by \code{by} for \code{i=1,...length(x)-1}.
}
\details{
The \code{=} is defined by function \code{\link[base]{identical}} by default.
This function can be changed by argument fun_for_identical
}
\examples{
x <- rep(c('a','b','c','d'), times=c(2,4,1,3))
x
\dontrun{replace_consecutive(x)}
# NA should not be identical. So change fun_for_identical
fun_for_identical <- function(x,y) !is.na(x) && !is.na(y) && identical(x,y)
x <- c(1,1,3,3,NA,NA, 4)
x
\dontrun{replace_consecutive(x, by="99")}
\dontrun{replace_consecutive(x, by="99", fun_for_identical = fun_for_identical)}

}
