#' Readable check functions to ensure code integrity.
#'
#' \code{assertive} contains lots of \code{is_*} functions to check the
#' state of your variables, and \code{assert_*} functions to throw errors
#' if they aren't in the right form.
#'
#' When the package loads, it creates a global option \code{"assertive.severity"}
#' that determines what happens when an \code{assert_*} function's 
#' input fails the condition.  By default, an error is thrown but it is 
#' possible to generate warnings or messages instead (see the examples).
#'
#' @docType package
#' @name assertive
#' @aliases assertive assertive-package
#' @examples
#' \dontrun{
#' is_numeric(1:10)
#' assert_are_all_positive(1:10)
#' old_op <- options(assertive.severity = "warning")
#' assert_is_scalar(runif(10))
#' options(old_op)
#' }
#' @author Richard Cotton \email{richierocks@@gmail.com}
NULL
