% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-matrix.R, R/is-matrix.R
\name{assert_is_square_matrix}
\alias{assert_is_square_matrix}
\alias{is_square_matrix}
\title{Is the matrix a square matrix?}
\usage{
assert_is_square_matrix(x, severity = getOption("assertive.severity",
  "stop"))

is_square_matrix(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{TRUE} if the input is all zeroes (after coercion to be a 
matrix).
}
\description{
Checks that the input is a square matrix.
}
\examples{
is_square_matrix(matrix(1:9, nrow = 3))
is_square_matrix(matrix(1:12, nrow = 3))
}
