% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-identical-to-true-false-na.R, R/assert-is-true-false-na.R, R/is-identical-to-true-false-na.R, R/is-true-false-na.R
\name{Truth}
\alias{Truth}
\alias{assert_all_are_false}
\alias{assert_all_are_na}
\alias{assert_all_are_not_false}
\alias{assert_all_are_not_na}
\alias{assert_all_are_not_true}
\alias{assert_all_are_true}
\alias{assert_any_are_false}
\alias{assert_any_are_na}
\alias{assert_any_are_not_false}
\alias{assert_any_are_not_na}
\alias{assert_any_are_not_true}
\alias{assert_any_are_true}
\alias{assert_is_identical_to_false}
\alias{assert_is_identical_to_na}
\alias{assert_is_identical_to_true}
\alias{is_false}
\alias{is_identical_to_false}
\alias{is_identical_to_na}
\alias{is_identical_to_true}
\alias{is_na}
\alias{is_not_false}
\alias{is_not_na}
\alias{is_not_true}
\alias{is_true}
\title{Is the input TRUE/FALSE/NA?}
\usage{
assert_is_identical_to_false(x, allow_attributes = FALSE)

assert_is_identical_to_na(x, allow_attributes = FALSE)

assert_is_identical_to_true(x, allow_attributes = FALSE)

assert_all_are_false(x)

assert_any_are_false(x)

assert_all_are_na(x)

assert_any_are_na(x)

assert_all_are_true(x)

assert_any_are_true(x)

assert_all_are_not_false(x)

assert_any_are_not_false(x)

assert_all_are_not_na(x)

assert_any_are_not_na(x)

assert_all_are_not_true(x)

assert_any_are_not_true(x)

is_identical_to_false(x, allow_attributes = FALSE,
  .xname = get_name_in_parent(x))

is_identical_to_na(x, allow_attributes = FALSE,
  .xname = get_name_in_parent(x))

is_identical_to_true(x, allow_attributes = FALSE,
  .xname = get_name_in_parent(x))

is_false(x)

is_na(x)

is_not_na(x)

is_not_false(x)

is_not_true(x)

is_true(x)
}
\arguments{
\item{x}{Input to check.}

\item{allow_attributes}{If \code{TRUE}, a scalar value of \code{TRUE}
with attributes is allowed.}

\item{.xname}{Not intended to be used directly.}
}
\value{
The \code{is*} functions return \code{TRUE} if the input is
\code{TRUE}/\code{FALSE}. The \code{assert_*} functions return nothing but
throw an error if the corresponding \code{is_*} function returns
\code{FALSE}.
}
\description{
Checks to see if the input is \code{TRUE},  \code{FALSE} or  \code{NA}.
}
\note{
\code{is_identical_to_true} wraps the base function \code{isTRUE},
providing more information on failure.  Likewise,
\code{is_identical_to_false} checks that the input is identical to FALSE.  If
\code{allow_attributes} is \code{TRUE}, a scalar value of \code{TRUE} with
attributes is allowed. \code{is_true} and \code{is_false} are vectorized,
returning \code{TRUE} when the inputs are \code{TRUE} and \code{FALSE}
respectively.
Note that in version 0.1-4 and prior, \code{is_identical_to_true/false} was
named \code{is_true/false} and the vectorized versions were not present.
}
\examples{
# Checks against logical values using base::identical
assert_is_identical_to_true(TRUE)
assert_is_identical_to_false(FALSE)
assert_is_identical_to_na(NA)

# Other NA types match
assert_is_identical_to_na(NA_complex_)

# NaN is not NA
dont_stop(assert_is_identical_to_na(NaN))

# For a slightly less strict test, you can ignore attributes
assert_is_identical_to_true(c(truth = TRUE), allow_attributes = TRUE)
assert_is_identical_to_false(matrix(FALSE), allow_attributes = TRUE)
assert_is_identical_to_na(structure(NA, class = "nanana"), allow_attributes = TRUE)

# Vectorized predicates
x <- c(TRUE, FALSE, NA)
is_true(x)
is_false(x)
is_na(x)

# ...and their opposites
is_not_true(x)
is_not_false(x)
is_not_na(x)

# Check that at least one element fits the condition
assert_any_are_true(x)
assert_any_are_false(x)
assert_any_are_na(x)

# These tests should fail:
dont_stop(assert_is_identical_to_true(c(truth = TRUE)))
dont_stop(assert_is_identical_to_false(matrix(FALSE)))
dont_stop(assert_is_identical_to_na(structure(NA, class = "nanana")))
dont_stop(assert_all_are_true(x))
dont_stop(assert_all_are_false(x))
dont_stop(assert_all_are_na(x))
}
\seealso{
\code{\link[base]{isTRUE}}.
}

