\name{print.ascii}
\alias{print.ascii}
\title{Print ascii object}
\description{Function displaying the AsciiDoc, txt2tags or textile code associated with the supplied object of class \code{ascii}.}
\usage{
print.ascii(x, type = getOption("asciiType"), ...)
}
\arguments{
  \item{x}{An object of class \code{"ascii"}}
  \item{type}{Type of syntax produce.  Possible values for \code{type} are \code{"asciidoc"}, \code{"t2t"} or \code{"textile"}.
              Default value produce AsciiDoc syntax.}
  \item{...}{Additional arguments.  (Currently ignored.)}
}
\details{
  The package provides the new global option \code{asciiType}. Default value is \code{"asciidoc"} (see examples).
}
\author{David Hajage \email{dhajage@gmail.com}}
\seealso{\code{\link{ascii}}}
\examples{
data(esoph)
ascii(esoph[1:10,])
print(ascii(esoph[1:10,]), type = "t2t")
print(ascii(esoph[1:10,]), type = "textile")
options(asciiType = "t2t")
ascii(esoph[1:10,])
options(asciiType = "asciidoc")
}
\keyword{print}
