% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.color.R
\name{as.color}
\alias{as.color}
\title{Create a unique set of colors that matched the unique set of inputs from a single vector.}
\usage{
as.color(x, alpha, seed)
}
\arguments{
\item{x}{A vector of any class and length. \code{x}}

\item{alpha}{A numeric value between 0 and 1 to control color transparency. Defualt is value is 0.5. \code{alpha}}

\item{seed}{A value to seed the random colors. If not provided, a new palette of random colors will be generated with each call to the function.}
}
\value{
output a vector of hexidecimal colors of length x will be returned.
}
\description{
Provided a vector of any class, the function  will return a set of colors
with the same length and order as the input vector. A random seed is used
and will be printed in order to save desireable color palettes.
Color transparency can also be modified.
}
\examples{
#simple data frame with factors
n <- 100
f <- 5
x <- sort(rnorm(n, mean = 0, sd = 50)) + rnorm(n, mean = 0, sd = 30)
fact <- rep(letters[1:5], each=n/f)
#call to as.color, with char vector
colz <- as.color(fact, alpha = 1)
plotx <- as.integer(as.factor(fact))
plot( jitter(plotx), x, col=colz, pch=19)
}

