% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{arrow_head_wittgenstein_rod}
\alias{arrow_head_wittgenstein_rod}
\title{Make arrowhead with Wittengenstein's Rod}
\usage{
arrow_head_wittgenstein_rod(
  fixed_point = c(1.1, 0),
  rod_length = 2.1,
  rotate = 0,
  rescale = c(1, 1),
  nudge = c(0, 0),
  transformations = c("unitizer", "rotater", "rescaler", "nudger"),
  n = 361,
  plot = FALSE
)
}
\arguments{
\item{fixed_point}{x and y coordinates of a point}

\item{rod_length}{Length of rod}

\item{rotate}{rotation angle in radians}

\item{rescale}{a single value or 2-length vector for scaling in x and y}

\item{nudge}{a single value or 2-length vector for nudging in x and y}

\item{transformations}{a vector of transformation functions}

\item{n}{number of points in polygon}

\item{plot}{plot arrowhead if TRUE}
}
\value{
a matrix
}
\description{
See https://en.wikipedia.org/wiki/Wittgenstein's_rod
}
\examples{
candleflame <- arrow_head_wittgenstein_rod(
  fixed_point = c(-2.75, 0),
  rod_length = 3.75,
  nudge = c(1, 0),
  rescale = .95,
  plot = TRUE
)


rocket <- arrow_head_wittgenstein_rod(
  fixed_point = c(1.1, 0),
  rod_length = 2.1,
  plot = TRUE,
  nudge = c(.1, 0),
  rescale = c(.90, .25)
)
}
