% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array.R
\docType{class}
\name{array}
\alias{array}
\alias{Array}
\title{Array class}
\description{
Array base type. Immutable data array with some logical type
and some length.
}
\section{Factory}{

The \code{Array$create()} factory method instantiates an \code{Array} and
takes the following arguments:
\itemize{
\item \code{x}: an R vector, list, or \code{data.frame}
\item \code{type}: an optional \link[=data-type]{data type} for \code{x}. If omitted, the type
will be inferred from the data.
}
}

\section{Usage}{
\preformatted{a <- Array$create(x)
length(a)

print(a)
a == a
}
}

\section{Methods}{

\itemize{
\item \code{$IsNull(i)}: Return true if value at index is null. Does not boundscheck
\item \code{$IsValid(i)}: Return true if value at index is valid. Does not boundscheck
\item \code{$length()}: Size in the number of elements this array contains
\item \code{$offset()}: A relative position into another array's data, to enable zero-copy slicing
\item \code{$null_count()}: The number of null entries in the array
\item \code{$type()}: logical type of data
\item \code{$type_id()}: type id
\item \code{$Equals(other)} : is this array equal to \code{other}
\item \code{$ApproxEquals(other)} :
\item \code{$data()}: return the underlying \link{ArrayData}
\item \code{$as_vector()}: convert to an R vector
\item \code{$ToString()}: string representation of the array
\item \code{$Slice(offset, length = NULL)} : Construct a zero-copy slice of the array with the indicated offset and length. If length is \code{NULL}, the slice goes until the end of the array.
\item \code{$RangeEquals(other, start_idx, end_idx, other_start_idx)} :
\item \code{$View(type)}: Construct a zero-copy view of this array with the given type.
\item \code{$Validate()} : Perform any validation checks to determine obvious inconsistencies
within the array's internal data. This can be an expensive check, potentially \code{O(length)}
}
}

\keyword{datasets}
