% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/1_ModelsHeader.R, R/2_SimpleModels.R, R/3_ComplexModels.R
\name{maxCustomers}
\alias{maxCustomers}
\alias{maxCustomers.M_M_1_INF_H}
\alias{maxCustomers.M_M_1_K}
\alias{maxCustomers.M_M_S_INF_H}
\alias{maxCustomers.M_M_S_INF_H_Y}
\alias{maxCustomers.M_M_S_K}
\alias{maxCustomers.MarkovianModel}
\title{Returns the maximun value of n that satisfies the condition \ifelse{latex}{\eqn{P_{n}}}{\out{P<sub>n</sub>}} > 0}
\usage{
maxCustomers(qm)

\method{maxCustomers}{M_M_S_INF_H}(qm)
}
\arguments{
\item{qm}{object MarkovianModel}
}
\description{
Returns the maximun value of n that satisfies the condition \ifelse{latex}{\eqn{P_{n}}}{\out{P<sub>n</sub>}} > 0
}
\details{
\code{maxCustomers.M_M_S_INF_H} implements the method for a M/M/s/\eqn{\infty}/H queueing model
}
\section{Methods (by class)}{
\itemize{
\item \code{MarkovianModel}: implements the default method. Returns infinite.

\item \code{M_M_1_K}: Implements the method for a M/M/1/K queueing model

\item \code{M_M_S_K}: Implements the method for a M/M/S/K queueing model

\item \code{M_M_1_INF_H}: Implements the method for a M/M/1/\eqn{\infty}/H queueing model

\item \code{M_M_S_INF_H_Y}: Implements the method for a M/M/s/\eqn{\infty}/H/Y queueing model
}}
\examples{
maxCustomers(M_M_1_K())

maxCustomers(M_M_S_INF_H_Y())
maxCustomers(M_M_S_INF_H(lambda=1/2, mu=60/5, s=2, h=5))
}

