% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aricode.R
\name{MARIraw}
\alias{MARIraw}
\title{raw Modified Adjusted Rand Index}
\usage{
MARIraw(c1, c2)
}
\arguments{
\item{c1}{a vector containing the labels of the first classification. Must be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{c2}{a vector containing the labels of the second classification.}
}
\value{
a scalar with the modified ARI without the division by the (maximum - expected)
}
\description{
A function to compute a modified adjusted rand index between two classifications as proposed by Sundqvist et al. in prep, based on a multinomial model. Raw means, that the index is not divided by the (maximum - expected) value.
}
\examples{
data(iris)
cl <- cutree(hclust(dist(iris[,-5])), 4)
MARIraw(cl,iris$Species)
}
\seealso{
\code{\link{ARI}}, \code{\link{NID}}, \code{\link{NVI}}, \code{\link{NMI}}, \code{\link{clustComp}}
}
