% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ari_document.R
\name{make_ari_document}
\alias{make_ari_document}
\alias{pngs_to_ari}
\title{Make an ari document}
\usage{
make_ari_document(
  images,
  script,
  output_file = NULL,
  open = interactive(),
  use_knitr = FALSE,
  ...,
  verbose = TRUE
)

pngs_to_ari(
  images,
  script,
  output_file = NULL,
  open = interactive(),
  use_knitr = FALSE,
  ...,
  verbose = TRUE
)
}
\arguments{
\item{images}{a vector of paths to images.}

\item{script}{a file or vector strings that will be spoken}

\item{output_file}{a path to the Rmd file which will be created.}

\item{open}{should the Rmd be opened after creating?}

\item{use_knitr}{use an Rmarkdown type syntax for including the images}

\item{...}{additional arguments to pass to \link[ari:ari_spin]{ari::ari_spin}}

\item{verbose}{print diagnostic messages and also passed to
\link[ari:ari_stitch]{ari::ari_stitch}}
}
\value{
A path to the document
}
\description{
Make an ari document
}
\examples{
images = system.file("extdata", c("example_1.png", "example_2.png"),
package = "ariExtra")
res = make_ari_document(images, script = c("hello", "how are you"))
res$output_file
res = make_ari_document(images, script = c("hello", "how are you"),
use_knitr = TRUE)
res$output_file

res = to_ari(images, script = c("hello", "how are you"), open = FALSE)
}
