% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityfcns.R
\name{print.summary.arfima}
\alias{print.summary.arfima}
\title{Prints the output of a call to \code{summary} on an \code{arfima} object}
\usage{
\method{print}{summary.arfima}(x, digits = max(6, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"), ...)
}
\arguments{
\item{x}{A \code{summary.arfima} object}

\item{digits}{The number of digits to print}

\item{signif.stars}{Whether to print stars on significant output}

\item{\dots}{Currently not used}
}
\value{
Returns the object \code{x} invisibly
}
\description{
Prints the output of a call to \code{summary} on an \code{arfima} object
}
\examples{

\donttest{
set.seed(54678)
sim <- arfima.sim(1000, model = list(phi = 0.9, H = 0.3))
fit <- arfima(sim, order = c(1, 0, 0), lmodel = "g", back=T)
summary(fit)
}

}
\references{
Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)
}
\seealso{
\code{\link{arfima}}, \code{\link{print.arfima}},
\code{\link{summary.arfima}}, \code{\link{print}}
}
\author{
JQ (Justin) Veenstra
}
\keyword{ts}
