% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw_weight.R
\name{aw_weight}
\alias{aw_weight}
\title{Calculate Areal Weight}
\usage{
aw_weight(.data, areaVar, totalVar, areaWeight)
}
\arguments{
\item{.data}{A \code{sf} object that has been intersected using \link{aw_intersect}}

\item{areaVar}{The name of the variable measuring a feature's area}

\item{totalVar}{The name of the variable containing total area field by \code{source} id}

\item{areaWeight}{The name of a new area weight field to be calculated}
}
\value{
A \code{sf} object with the intersected data and new area weight field.
}
\description{
\code{aw_weight} creates an area weight field by dividing the area
    field by the total area field. This is the third step in the interpolation
    process after \link{aw_weight}.
}
\examples{
library(dplyr)

race <- select(ar_stl_race, GEOID, TOTAL_E)
wards <- select(ar_stl_wards, WARD)

wards \%>\%
    aw_intersect(source = race, areaVar = "area") \%>\%
    aw_total(source = race, id = GEOID, areaVar = "area", totalVar = "totalArea",
             weight = "sum", type = "extensive") -> intersect

aw_weight(intersect, areaVar = "area", totalVar = "totalArea", areaWeight = "areaWeight")

}
