% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sp_rel_lookups}
\alias{sp_rel_lookups}
\alias{sp_rel_valid}
\alias{sp_rel_lookup}
\title{Spatial relationship descriptor and lookup tables}
\format{
\code{sp_rel_valid} is a data.frame with 105 rows and 3 variables as
follows:
\describe{
  \item{feature_class}{A feature class to be queried}
  \item{query_feature_class}{The feature class used to do a spatial query}
  \item{sp_rel}{
    The spatial relationships that are valid for the feature class and
    query_feature_class combination
  }
}

\code{sp_rel_lookup} is a data.frame with 9 rows and 2 variables as
follows:
\describe{
  \item{sp_rel}{The spatial relationship being described}
  \item{description}{A description of the sp_rel}
}
}
\source{
sp_rel_valid--Independent tests done specifically by and for arcpullr

sp_rel_lookup --
\url{https://help.arcgis.com/en/webapi/wpf/apiref/ESRI.ArcGIS.Client~ESRI.ArcGIS.Client.Tasks.SpatialRelationship.html
}
}
\usage{
sp_rel_valid

sp_rel_lookup
}
\description{
These data.frames are used to lookup and explain which spatial relation types
go with different spatial queries.
}
\details{
sp_rel_lookup explains the various different types of spatial relationships
available through ArcGIS REST APIs. sp_rel_valid shows which spatial
relationships are valid with different geometry types being queried and
used to do spatial queries
}
\keyword{datasets}
