% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createEmptyRepo.R
\name{createLocalRepo}
\alias{createLocalRepo}
\alias{createPostgresRepo}
\alias{createEmptyRepo}
\title{Create an Empty Repository}
\usage{
createLocalRepo(repoDir, force = FALSE, default = FALSE)

createPostgresRepo(repoDir, connector, force = FALSE, default = FALSE)

createEmptyRepo(...)
}
\arguments{
\item{repoDir}{A character that specifies the directory for the Repository which is to be made.}

\item{force}{If \code{force = TRUE} and \code{repoDir} parameter specifies the directory that contains backpack.db file,
then function call will force to recreate new \code{backpack.db}
Default set to \code{force = FALSE}.}

\item{default}{If \code{default = TRUE} then \code{repoDir} is set as default Local Repository.}

\item{connector}{If user want to use some external database instead of SQLite, then the \code{connector} shall be the function that create a \code{DBI} connection with the database.
Within every transaction the connection is opened and closed, thus the \code{connector} function will be executed often and shall not be computationally heavy.
See the Examples section for some examples.
Note that it's an experimental feature.}

\item{...}{All arguments are being passed to \code{createLocalRepo}.}
}
\description{
\code{createLocalRepo} creates an empty \link{Repository} in the given directory in which archived artifacts will be stored.
}
\details{
At least one Repository must be initialized before using other functions from the \pkg{archivist} package. 
While working in groups, it is highly recommended to create a Repository on a shared Dropbox/GitHub folder.

All artifacts which are desired to be archived are going to be saved in the local Repository, which is an SQLite 
database stored in a file named \code{backpack}. 
After calling \code{saveToRepo} function, each artifact will be archived in a \code{md5hash.rda} file. 
This file will be saved in a folder (under \code{repoDir} directory) named 
\code{gallery}. For every artifact, \code{md5hash} is a unique string of length 32 that is produced by
\link[digest]{digest} function, which uses a cryptographical MD5 hash algorithm.

To learn more about artifacts visit \link[archivist]{archivist-package}.

Created \code{backpack} database is a useful and fundamental tool for remembering artifact's 
\code{name}, \code{class}, \code{archiving date} etc. (the so called \link{Tags})
or for keeping artifact's \code{md5hash}.

Besides the \code{backpack} database, \code{gallery} folder is created in which all 
artifacts will be archived.

After every \code{saveToRepo} call the database is refreshed. As a result, the artifact is available 
immediately in \code{backpack.db} database for other collaborators.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{
\dontrun{
exampleRepoDir <- tempfile()
createLocalRepo( repoDir = exampleRepoDir, default =  TRUE )
data(iris)
saveToLocalRepo(iris)
showLocalRepo()
showLocalRepo(method = "tags")
deleteLocalRepo( repoDir = exampleRepoDir, unset = TRUE, deleteRoot = TRUE)

# example with external database
# create a connector
require("RPostgreSQL")
drv <- dbDriver("PostgreSQL")
connector <- function() {
  dbConnect(drv, dbname = "postgres",
            host = "localhost", port = 5432,
            user = "user", password = pw)
}
# Now you can create an empty repository with postgress database
exampleRepoDir <- tempfile()
createPostgresRepo( repoDir = exampleRepoDir, connector)
data(iris)
saveToLocalRepo(iris)
showLocalRepo()
showLocalRepo(method = "tags")
deleteLocalRepo( repoDir = exampleRepoDir, unset = TRUE, deleteRoot = TRUE)

}
}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}

Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}

Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\concept{archivist}
