% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/setRepo.R
\name{setLocalRepo}
\alias{setGithubRepo}
\alias{setLocalRepo}
\title{Set Global Path to Repository}
\usage{
setLocalRepo(repoDir)

setGithubRepo(user, repo, branch = "master", repoDirGit = NULL)
}
\arguments{
\item{repoDir}{A character denoting an existing directory of a Rpoesiotry that will be used in
functions: \link{saveToRepo}, \link{loadFromLocalRepo}, \link{searchInLocalRepo},
\link{rmFromRepo}, \link{zipLocalRepo}, \link{multiSearchInLocalRepo}, \link{addTagsRepo},
\link{shinySearchInLocalRepo}, \link{getTagsLocal}, \link{showLocalRepo},
\link{summaryLocalRepo} if in their
calls there will not be specified a \code{repoDir} parameter.}

\item{user}{Only if working with a Github repository. A character containing a name of a Github user that will be used in
functions: \link{zipGithubRepo}, \link{loadFromGithubRepo}, \link{searchInGithubRepo}, \link{getTagsGithub}, \link{showGithubRepo}, \link{summaryGithubRepo},\link{multiSearchInGithubRepo}, \link{copyGithubRepo} if in their
calls there will not be specified a \code{user} parameter.}

\item{repo}{Only if working with a Github repository. A character containing a name of a Github repository that will be used in
functions: \link{zipGithubRepo}, \link{loadFromGithubRepo}, \link{searchInGithubRepo}, \link{getTagsGithub}, \link{showGithubRepo}, \link{summaryGithubRepo}, \link{multiSearchInGithubRepo}, \link{copyGithubRepo} if in their
calls there will not be specified a \code{repo} parameter.}

\item{branch}{Only if working with a Github repository. A character containing a name of
Github Repository's branch that will be used in
functions: \link{zipGithubRepo}, \link{loadFromGithubRepo}, \link{searchInGithubRepo}, \link{getTagsGithub}, \link{showGithubRepo}, \link{summaryGithubRepo}, \link{multiSearchInGithubRepo}, \link{copyGithubRepo} if in their
calls there will not be specified a \code{branch} parameter.}

\item{repoDirGit}{Only if working with a Github repository. A character containing a name of a directory on Github repository
on which the Repository is stored that will be used in
functions: \link{zipGithubRepo}, \link{loadFromGithubRepo}, \link{searchInGithubRepo}, \link{getTagsGithub}, \link{showGithubRepo}, \link{summaryGithubRepo}, \link{multiSearchInGithubRepo}, \link{copyGithubRepo} if in their
calls there will not be specified a \code{repoDirGit} parameter. If the Repository is stored in main folder on Github repository, this should be set
to \code{repoDirGit = FALSE} as default.}
}
\description{
\code{setLocalRepo} sets global path to the \link{Repository}. If you are working on
a Local Repository and are tired of specifying \code{repoDir} argument with every call
of a function that works with the Repository, you can set the path globally using
\code{setLocalRepo} function and than ommit \code{repoDir} parameter in future calls.
\code{setGithubRepo} similarly sets path to the Github Repository stored on a Github. See examples.
}
\details{
\code{setLocalRepo} sets a global path to the \link{Repository}. If you are working on
a Local Repository and are tired of specifying a \code{repoDir} paremeter with every call
of a function that works with the Repository, you can set the path globally using
\code{setLocalRepo} function and than ommit the \code{repoDir} parameter in future calls.
\code{setGithubRepo} similarly sets path to the Github Repository stored on a Github. See examples.
}
\examples{
\dontrun{
# examples
exampleRepoDir <- tempdir()
createEmptyRepo( repoDir = exampleRepoDir )
saveToRepo( iris, exampleRepoDir)
setLocalRepo( exampleRepoDir )
saveToRepo( swiss )
showLocalRepo( exampleRepoDir )

iris2 <- loadFromLocalRepo( "ff575c2" , value = TRUE)
head(iris2, 2)

searchInLocalRepo( "name:i", fixed = F)

getTagsLocal( "ff575c261c949d073b2895b05d1097c3" )

rmFromRepo( "4c43f" )
showLocalRepo( )
summaryLocalRepo( )

deleteRepo( exampleRepoDir, TRUE)
rm( exampleRepoDir )

## Github version
setGithubRepo( user="MarcinKosinski", repo="Museum", branch="master",
repoDirGit="ex1" )

loadFromGithubRepo( "ff575c261c949d073b2895b05d1097c3")
this <- loadFromGithubRepo( "ff", value = T)
zipGithubRepo( )
searchInGithubRepo( "name:", fixed= FALSE)
getTagsGithub("ff575c261c949d073b2895b05d1097c3")

summaryGithubRepo( )
showGithubRepo( )

setGithubRepo( user="pbiecek", repo="archivist" )

multiSearchInGithubRepo( patterns=c("varname:Sepal.Width", "class:lm", "name:myplot123"),
                         intersect = FALSE )

}
}
\author{
Marcin Kosinski , \email{m.p.kosinski@gmail.com}
}
\seealso{
\href{https://github.com/pbiecek/archivist/wiki}{https://github.com/pbiecek/archivist/wiki}

Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}}; \code{\link{aoptions}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}

Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}}; \code{\link{aoptions}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

