\name{frag.layers.cohesion}
\alias{frag.layers.cohesion}

\title{Cohesion measure of layers}
\description{Returns the cohesion value of two stratigraphic layers (or any other type of archeological spatial units). Must be used after weighting the edges with \code{frag.edges.weighting}.}
\usage{frag.layers.cohesion(graph, layer.attr)}

\arguments{
  \item{graph}{An undirected \code{igraph} object.} 
  \item{layer.attr}{Character. The name of the vertices attribute giving the layer of the fragments.}
}
\details{
The cohesion value of a spatial unit  is computed as: 

	\deqn{\frac{V_{unit_i} + W_{unit_i}}{ \sum_{j=1}^{2} V_{unit_j} + W_{unit_j}} }
	
with V the number of vertices in the unit and W the sum of the edge weights within the unit.

The measure takes into account the balance between the information about each layer.
Results range in [0;1], with 0 for two layers with only inter-layer connection relationships, and 1 if there are not inter-layer relationships and a  significant imbalance of information on the two layers.

The basic use of this function is intended for a graph with two layers, whose edges have been previously weighted using the \code{frag.edges.weighting} function (an error message is displayed if the vertice attribute "layer" contains less than two layers, and if the graph does not have an edge attribute "weight").

However, this function can also be used for a graph with more than two layers. In this case, a subgraph is generated for each pair of layers (using the \code{frag.get.layers.pair} function), the \code{frag.edges.weighting} function is applied to weight their edges (a warning message is displayed), and the cohesion is computed.
}
\value{
If the graph has only two layers, the function returns a numeric vector with a cohesion value ([0;1]) for each layer (sorted in alphanumerical order).
If the graph has more than two layers, the function returns a matrix with a cohesion value for each pair of layers.
}
\author{Sebastien Plutniak <sebastien.plutniak at posteo.net>}

\seealso{
\code{\link[archeofrag]{frag.edges.weighting}},
\code{\link[archeofrag]{frag.get.layers.pair}}
}
\examples{
g <- frag.simul.process(n.components=20, vertices=50, disturbance=.1)
frag.layers.cohesion(g, layer.attr="layer")
}
 
\keyword{measurement}
