% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_extent}
\alias{as_extent}
\title{Convert an object to an extent}
\usage{
as_extent(x, crs = sf::st_crs(x))
}
\arguments{
\item{x}{an sf or sfc object}

\item{crs}{the CRS of the object. Must be parsable by \code{sf::st_crs()}}
}
\value{
An extent json object. Use \code{jsonify::to_json(x, unbox = TRUE)} to convert
to json.
}
\description{
Given an sf or sfc object create a list that represents the extent of the
object. The result of this function can be parsed directly into json using
\code{jsonify::to_json(x, unbox = TRUE)} or included into a list as the extent
component that will be eventually converted into json using the above function.
}
\examples{
nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
as_extent(nc)
}
