% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitLogicErrors.R
\name{splitLogicErrors}
\alias{splitLogicErrors}
\title{Split a \code{SoilProfileCollection} into a list based on types of horizon logic errors}
\usage{
splitLogicErrors(object, interact = FALSE, ...)
}
\arguments{
\item{object}{A \code{SoilProfileCollection}}

\item{interact}{Calculate interaction between the four logic errors for groups? Default: \code{FALSE} always returns 4 groups, one for each logic error type.}

\item{...}{Additional arguments to \code{split.default}, called when \code{interact = TRUE}}
}
\value{
A named list of \code{SoilProfileCollections} (or \code{NULL}), with names: "depthLogic", "sameDepth", "missingDepth", "overlapOrGap". If \code{interact = TRUE} then the list elements groups determined by \code{interaction()} of the error types.
}
\description{
Uses \code{checkHzDepthLogic()} to identify presence of depth logic errors, same depths, missing depths, and overlaps/gaps between the horizons of each profile in a \code{SoilProfileCollection.}
}
\examples{

data(sp4)
depths(sp4) <- id ~ top + bottom

# no errors (all four list elements return NULL)
splitLogicErrors(sp4)

# NA in top depth triggers depth logic and missing depth errors
data(sp4)
sp4$top[1] <- NA
depths(sp4) <- id ~ top + bottom

splitLogicErrors(sp4)

# interact = TRUE gets errors for profile 1 in same group
#  and allows you to pass extra arguments to split.default()
splitLogicErrors(sp4, interact = TRUE, sep = "_", drop = TRUE)

}
