% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_apsimx_json.R
\name{edit_apsimx}
\alias{edit_apsimx}
\title{Edit an APSIM-X (JSON) Simulation}
\usage{
edit_apsimx(
  file,
  src.dir = ".",
  wrt.dir = NULL,
  node = c("Clock", "Weather", "Soil", "SurfaceOrganicMatter", "MicroClimate", "Crop",
    "Manager", "Report", "Operations", "Other"),
  soil.child = c("Metadata", "Water", "SoilWater", "Organic", "Physical", "Analysis",
    "Chemical", "InitialWater", "Sample", "Solute", "NO3", "NH4", "Urea", "Swim3"),
  manager.child = NULL,
  parm = NULL,
  value = NULL,
  overwrite = FALSE,
  edit.tag = "-edited",
  parm.path = NULL,
  root = NULL,
  verbose = TRUE
)
}
\arguments{
\item{file}{file ending in .apsimx to be edited (JSON)}

\item{src.dir}{directory containing the .apsimx file to be edited; defaults to the current working directory}

\item{wrt.dir}{should be used if the destination directory is different from the src.dir}

\item{node}{either \sQuote{Clock}, \sQuote{Weather}, \sQuote{Soil}, 
\sQuote{SurfaceOrganicMatter}, \sQuote{MicroClimate}, \sQuote{Crop}, \sQuote{Manager}, \sQuote{Report}, \sQuote{Operations} or \sQuote{Other}}

\item{soil.child}{specific soil component to be edited}

\item{manager.child}{specific manager component to be edited}

\item{parm}{parameter to be edited. It can be a regular expression.}

\item{value}{new values for the parameter to be edited}

\item{overwrite}{logical; if \code{TRUE} the old file is overwritten, a new file is written otherwise}

\item{edit.tag}{if the file is edited a different tag from the default \sQuote{-edited} can be used.}

\item{parm.path}{path to the attribute to edit when node is \sQuote{Other}}

\item{root}{supply the node position in the case of multiple simulations such as factorials.}

\item{verbose}{whether to print information about successful edit}
}
\value{
(when verbose=TRUE) complete file path to edited .apsimx file is returned as a character string.
As a side effect this function creates a new (JSON) .apsimx file.
}
\description{
This function allows editing of an APSIM-X (JSON) simulation file.
}
\details{
The variables specified by \code{parm} within the .apsimx file specified by \code{file} 
in the source directory \code{src.dir} are edited. The old values are replaced with \code{value}, which
is a list that has the same number of elements as the length of the vector \code{parm}.  The current
.apsimx file will be overwritten if \code{overwrite} is set to \code{TRUE}; otherwise the file
\sQuote{file} \emph{-edited.apsimx} will be created.  If (verbose = TRUE) then the name
 of the written file is returned. 
 
 When node equals \sQuote{Report}, the editing allows to add variables, but not to remove them at the moment.

 When node equals Operations, \sQuote{parm} should have a list with two elements. The first should be the line(s) to edit and 
 the second should be the component(s) to edit. Either \sQuote{Date}, \sQuote{Action} or \sQuote{Line}.
 When more than one line is edited, \sQuote{value} should be a character vector of the same length as the number of
 lines to edit. It is possible to remove, say, line 10 by using \sQuote{parm = list(-10, NA)}. It is safer to remove
 lines at the end of \sQuote{Operations}. To remove several use the following \sQuote{parm = list(-c(10:12), NA)}. 
 This assumes that \sQuote{12} is the maximum number of lines present. Trying to remove lines in the middle will have 
 unexpected effects. It is possible to create additional lines, but only by using \sQuote{Date} first. This feature
 has not been tested much so use it carefully.
}
\examples{
\donttest{
## This example will read one of the examples distributed with APSIM-X
## but write to a temporary directory
tmp.dir <- tempdir()

## Edit Bulk density
extd.dir <- system.file("extdata", package = "apsimx")
bds <- c(1.02, 1.03, 1.09, 1.16, 1.18, 1.19, 1.20)
edit_apsimx("Wheat.apsimx", src.dir = extd.dir,
            wrt.dir = tmp.dir,
            node = "Soil",
            soil.child = "Physical", 
            parm = "BD", value = bds,
            verbose = FALSE)
## Inspect file
inspect_apsimx("Wheat-edited.apsimx", src.dir = tmp.dir,
                node = "Soil", soil.child = "Physical")
## To delete the file...
file.remove(file.path(tmp.dir, "Wheat-edited.apsimx"))

## Edit the fertilizer amount in 'Maize.apsimx'
edit_apsimx("Maize.apsimx", src.dir = extd.dir,
             wrt.dir = tmp.dir, node = "Manager",
             manager.child = "SowingFertiliser",
             parm = "Amount", value = 200, verbose = TRUE)
             
## Make sure it worked
inspect_apsimx("Maize-edited.apsimx", src.dir = tmp.dir, 
               node = "Manager",
               parm = list("SowingFertiliser", NA))

## Remove the file
file.remove(file.path(tmp.dir, "Maize-edited.apsimx"))
}

}
