% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsimx_soil_profile.R
\name{apsimx_soil_profile}
\alias{apsimx_soil_profile}
\alias{plot.soil_profile}
\alias{check_apsimx_soil_profile}
\title{Create APSIM-X Soil Profiles}
\usage{
apsimx_soil_profile(
  nlayers = 10,
  Depth = NULL,
  Thickness = NULL,
  BD = NULL,
  AirDry = NULL,
  LL15 = NULL,
  DUL = NULL,
  SAT = NULL,
  KS = NULL,
  crop.LL = NULL,
  crop.KL = NULL,
  crop.XF = NULL,
  Carbon = NULL,
  SoilCNRatio = NULL,
  FOM = NULL,
  FOM.CN = NULL,
  FBiom = NULL,
  FInert = NULL,
  NO3N = NULL,
  NH4N = NULL,
  PH = NULL,
  ParticleSizeClay = NULL,
  ParticleSizeSilt = NULL,
  ParticleSizeSand = NULL,
  soil.bottom = 150,
  water.table = 200,
  soil.type = 0,
  crops = c("Maize", "Soybean", "Wheat"),
  metadata = NULL,
  soilwat = NA,
  swim = NA,
  initialwater = NA,
  soilorganicmatter = NA,
  dist.parms = list(a = 0, b = 0.2),
  check = TRUE
)

\method{plot}{soil_profile}(
  x,
  ...,
  property = c("all", "water", "BD", "AirDry", "LL15", "DUL", "SAT", "KS", "Carbon",
    "SoilCNRatio", "FOM", "FOM.CN", "FBiom", "FInert", "NO3N", "NH4N", "PH")
)

check_apsimx_soil_profile(x, particle.density = 2.65)
}
\arguments{
\item{nlayers}{Number of soil layers (default = 10)}

\item{Depth}{specific depths for each soil layer (cm)}

\item{Thickness}{thickness for each soil layer (mm)}

\item{BD}{bulk density for each soil layer (g/cc) -- \sQuote{cc} is cubic cm}

\item{AirDry}{air dry for each soil layer (mm/mm)}

\item{LL15}{lower limit (15 bar) for each soil layer (mm/mm)}

\item{DUL}{drainage upper limit (0.33 bar) for each soil layer (mm/mm)}

\item{SAT}{saturation (0 bar) for each soil layer (mm/mm)}

\item{KS}{saturated hydraulic conductivity (mm/day)}

\item{crop.LL}{lower limit for a specific crop}

\item{crop.KL}{root ability to extract water for a specific crop}

\item{crop.XF}{soil root exploration for a specific crop}

\item{Carbon}{organic carbon (percent)}

\item{SoilCNRatio}{organic carbon C:N ratio}

\item{FOM}{fresh organic matter (kg/ha)}

\item{FOM.CN}{fresh organic matter C:N ratio}

\item{FBiom}{Fraction of microbial biomass (0-1)}

\item{FInert}{Fraction of inert carbon (0-1)}

\item{NO3N}{nitrate nitrogen (Chemical) (ppm)}

\item{NH4N}{ammonium nitrogen (Chemical) (ppm)}

\item{PH}{soil pH}

\item{ParticleSizeClay}{particle size clay (in percent)}

\item{ParticleSizeSilt}{particle size silt (in percent)}

\item{ParticleSizeSand}{particle size sand (in percent)}

\item{soil.bottom}{bottom of the soil profile (cm)}

\item{water.table}{water table level (not used at the moment) (cm)}

\item{soil.type}{might use it in the future for auto filling missing information}

\item{crops}{name of crops being grown}

\item{metadata}{list with soil metadata. For possible parameters and values see an example of \code{\link{inspect_apsimx}} with soil.child = \dQuote{Metadata}.}

\item{soilwat}{optional \sQuote{list} of class \sQuote{soilwat_parms}}

\item{swim}{optional \sQuote{list} of class \sQuote{swim_parms}}

\item{initialwater}{optional \sQuote{list} of class \sQuote{initialsoilwater_parms}}

\item{soilorganicmatter}{optional \sQuote{list} of class \sQuote{soilorganicmatter_parms}}

\item{dist.parms}{parameter values for creating a profile. If a == 0 and b == 0 then \cr
a constant value of 1 is used. If a == 0 and b != 0, then an exponential decay is used. \cr
If a != 0 and b != 0 then the equation is \code{a*soil.layer*exp(-b*soil.layer)}.}

\item{check}{whether to check for reasonable values using \code{\link{check_apsimx_soil_profile}}}

\item{x}{object of class \sQuote{soil_profile} or the \sQuote{soil} 
component within an object of class \sQuote{soil_profile}.}

\item{...}{additional plotting arguments (none use at the moment).}

\item{property}{\dQuote{all} for plotting all soil properties, \dQuote{water} for just SAT, DUL and LL15}

\item{particle.density}{default value for soil particle density (2.65 g/cm3)}
}
\value{
a soil profile with class \sQuote{soil_profile} with elements \sQuote{soil}, \sQuote{crops}, \sQuote{metadata},
\sQuote{soilwat} and \sQuote{swim}.

it produces a plot

It does not produce output unless potential issues are found. Only warnings
are produced and it returns an object of class \sQuote{soil_profile}.
}
\description{
Generates a soil profile that can then replace the existing one in an \sQuote{.apsimx} or \sQuote{.apsim} simulation file

plotting function for a soil profile, it requires \sQuote{ggplot2}

checking an apsimx soil profile for reasonable values
}
\details{
Soil Profiles

Real soils might have discontinuities, but for APSIM it might be beneficial to be able to create 
a soil profile with an arbitrary number of layers and have flexibility in the 
distribution of soil physical and chemical properties. Steps:
 
 1. \code{\link{apsimx_soil_profile}} is a function which can create a soil matrix with many layers \cr
 2. It allows for creating a smooth distribution for Physical (or Water), Chemical, InitialWater, Analysis, InitialN, Organic or SoilOrganicMatter \cr
 3. The distribution can be specified with the \sQuote{a} and \sQuote{c} parameter of an exponential decay function, using a list. E.g. DUL = list(0.35, 0, -0.1).
 This means that the top value for DUL will be 0.35 and it will decay with a rate of -0.1. \cr
 4. If an increase and then a decay is needed the Ricker function can be used. See \sQuote{SSricker} in the \sQuote{nlraa} package. \cr

The value of soil particle density (2.65 g/cm3) is hard coded in APSIM. 
https://en.wikipedia.org/wiki/Bulk_density
}
\examples{
\donttest{
 sp <- apsimx_soil_profile()
 require(ggplot2)
 plot(sp)
 }

}
