% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_apsim_replace_soil_profile.R
\name{edit_apsim_replace_soil_profile}
\alias{edit_apsim_replace_soil_profile}
\title{Edit APSIM \sQuote{Classic} file with a replaced soil profile}
\usage{
edit_apsim_replace_soil_profile(
  file = "",
  src.dir = ".",
  wrt.dir = NULL,
  soil.profile = NULL,
  swim = NULL,
  soilwat = NULL,
  edit.tag = "-edited",
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{file}{name of the .apsim file to be edited}

\item{src.dir}{source directory}

\item{wrt.dir}{writing directory}

\item{soil.profile}{a soil profile object with class \sQuote{soil_profile}}

\item{swim}{list with SWIM specific parameters}

\item{soilwat}{list with SoilWat specific parameters}

\item{edit.tag}{default edit tag \sQuote{-edited}}

\item{overwrite}{default FALSE}

\item{verbose}{default TRUE. Will print messages indicating what was done.}
}
\value{
writes a file to disk with the supplied soil profile
}
\description{
Edits an APSIM Classic simulation by replacing the soil profile
}
\details{
This function is designed to batch replace the whole soil in an APSIM simulation.
}
\note{
There is no such thing as a default soil, carefully build the profile for each simulation.
This function replaces values and it can grow an XML node, but it cannot edit a property
which is not present in the original file.
}
\examples{
\donttest{
sp <- apsimx_soil_profile(nlayers = 20,
                          crops = c("Barley", "Chickpea", "Lucerne", 
                          "Maize", "Perennial Grass", "Sorghum", 
                          "Wheat", "Millet"))

extd.dir <- system.file("extdata", package = "apsimx")

## Writing to a temp directory
tmp.dir <- tempdir()
edit_apsim_replace_soil_profile("Millet.apsim", soil.profile = sp, 
                                edit.tag = "-newsoil",
                                src.dir = extd.dir, 
                                wrt.dir = tmp.dir)
                                
inspect_apsim("Millet-newsoil.apsim", src.dir = tmp.dir,
              node = "Soil", soil.child = "Water")
 }

}
