% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wasserstein_distance.R
\name{wasserstein}
\alias{wasserstein}
\title{Calculate the Wasserstein distance}
\usage{
wasserstein(
  X = NULL,
  Y = NULL,
  a = NULL,
  b = NULL,
  cost = NULL,
  tplan = NULL,
  p = 2,
  ground_p = 2,
  method = transport_options(),
  cost_a = NULL,
  cost_b = NULL,
  ...
)
}
\arguments{
\item{X}{The covariate data of the first sample.}

\item{Y}{The covariate data of the second sample.}

\item{a}{Optional. Empirical measure of the first sample}

\item{b}{Optional. Empirical measure of the second sample}

\item{cost}{Specify the cost matrix in advance.}

\item{tplan}{Give a transportation plan with slots "from", "to", and "mass", like that returned by the [tranportation_plan][transportation_plan] function.}

\item{p}{The power of the Wasserstein distance}

\item{ground_p}{The power of the Lp norm}

\item{method}{Which transportation method to use. See [transport_options][transport_options]}

\item{cost_a}{The cost matrix for the first sample with itself. Only used for unbiased Sinkhorn}

\item{cost_b}{The cost matrix for the second sample with itself. Only used for unbiased Sinkhorn}

\item{...}{Additional arguments for various methods:
\itemize{
\item{"niter":}{ The number of iterations to use for the entropically penalized optimal transport distances}
\item{"epsilon":}{ The multiple of the median cost to use as a penalty in the entropically penalized optimal transport distances}
\item{"unbiased":}{ If using Sinkhorn distances, should the distance be de-biased? (TRUE/FALSE)}
\item{"nboot":}{ If using sliced Wasserstein distances, specify the number of Monte Carlo samples}
}}
}
\value{
The p-Wasserstein distance, a numeric value
}
\description{
Calculate the Wasserstein distance
}
\examples{
set.seed(11289374)
n <- 100
z <- stats::rnorm(n)
w <- stats::rnorm(n)
uni <- approxOT::wasserstein(X = z, Y = w, 
p = 2, ground_p = 2, 
observation.orientation = "colwise", 
method = "univariate")
}
