% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opdRef.R
\name{opdRef}
\alias{opdRef}
\title{OPD Reference Points: Empirical vs Uniform Baselines}
\usage{
opdRef(p)
}
\arguments{
\item{p}{A probability vector of length \eqn{k} giving the empirical
distribution of the observed ordinal outcome \eqn{Y\in\{1,\dots,k\}}.
Each entry must be nonnegative and the entries must sum to 1.}
}
\value{
A named numeric vector of length two:
  \code{c(OPDempDist = ..., OPDur = ...)}.
}
\description{
Computes two reference values for the Ordinal Prediction Disagreement (OPD):
(i) the expected OPD when the predicted label \eqn{\hat Y} follows the *same*
empirical distribution as \eqn{Y}; and (ii) the expected OPD when
\eqn{\hat Y} is *uniform* over the \eqn{k} ordered categories while \eqn{Y}
retains its empirical distribution. These values are useful as dataset-specific
anchors for interpreting raw OPD and for constructing normalized benchmarks.
}
\details{
Let \eqn{p=(p_1,\dots,p_k)} denote the empirical distribution of \eqn{Y}.
The function returns two scalars:
\itemize{
  \item \code{OPDempDist}: \eqn{\mathbb{E}|\,\hat Y-Y\,|} when
        \eqn{\hat Y\sim p} independently of \eqn{Y\sim p}.
  \item \code{OPDur}: \eqn{\mathbb{E}|\,\hat Y-Y\,|} when
        \eqn{\hat Y\sim \mathrm{Unif}\{1,\dots,k\}} independently of
        \eqn{Y\sim p}.
}
Both are computed via the disagreement-level decomposition
\deqn{\mathbb{E}|\,\hat Y-Y\,|
      = \sum_{d=0}^{k-1} d \;\mathbb{P}(|\hat Y-Y|=d),}
where, for the uniform case,
\deqn{\mathrm{OPD}_{UR}=\frac{1}{k}\sum_{d=0}^{k-1}
      d\Big[\mathbb{P}\{Y\le k-d\}-\mathbb{P}\{Y\le d\} + \mathbb{P}\{Y\ge d+1\}\Big],}
which is the discrete-\eqn{\{1,\dots,k\}} version of the expression shown in the manuscript.
}
\examples{
# Example with k = 5 categories and an empirical distribution p:
p <- c(0.10, 0.20, 0.40, 0.20, 0.10)
opdRef(p)

}
\seealso{
\code{\link[apor:nopa]{nopa}},
\code{\link[apor:ordPredArgmax]{ordPredArgmax}},
\code{\link[apor:ordPredRandom]{ordPredRandom}}
}
