% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_varcov.R
\name{apollo_varcov}
\alias{apollo_varcov}
\title{Calculates variance-covariance matrix of an Apollo model}
\usage{
apollo_varcov(apollo_beta, apollo_fixed, varcov_settings)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values of parameters at which to calculate the covariance matrix.
Values \strong{must not be scaled}, and they must include any fixed parameter.}

\item{apollo_fixed}{Character vector. Names of fixed parameters.}

\item{varcov_settings}{List of settings defining the behaviour of this function. It must contain at least one of
the following: \code{apollo_logLike}, \code{apollo_grad} or \code{apollo_inputs} together with \code{apollo_probabilities}.
\itemize{
  \item \strong{\code{apollo_grad}}: Function to calculate the gradient of the model, as returned by \link{apollo_makeGrad}.
  \item \strong{\code{apollo_inputs}}: List grouping most common inputs. Created by function \link{apollo_validateInputs}.
  \item \strong{\code{apollo_logLike}}: Function to calculate the log-likelihood of the model, as returned by \link{apollo_makeLogLike}.
  \item \strong{\code{apollo_probabilities}}: apollo_probabilities Function. Returns probabilities of the model to be estimated. Must receive three arguments:
  \itemize{
    \item \strong{\code{apollo_beta}}: Named numeric vector. Names and values of model parameters.
    \item \strong{\code{apollo_inputs}}: List containing options of the model. See \link{apollo_validateInputs}.
    \item \strong{\code{functionality}}: Character. Can be either 
    \strong{\code{"components"}}, \strong{\code{"conditionals"}}, \strong{\code{"estimate"}} (default), \strong{\code{"gradient"}}, \strong{\code{"output"}}, \strong{\code{"prediction"}}, \strong{\code{"preprocess"}}, \strong{\code{"raw"}}, \strong{\code{"report"}}, \strong{\code{"shares_LL"}}, \strong{\code{"validate"}} or \strong{\code{"zero_LL"}}.
  }
  \item \strong{\code{BHHH_matrix}}: Matrix. Optional input, providing the BHHH matrix so it does not get recalculated.
  \item \strong{\code{hessianRoutine}}: Character. Name of routine used to calculate the Hessian. Valid values are \code{"analytic"}, \code{"numDeriv"}, \code{"maxLik"} or \code{"none"} to avoid estimating the Hessian and covariance matrix.
  \item \strong{\code{numDeriv_settings}}: List. Additional arguments to the Richardson method used by numDeriv to calculate the Hessian. See argument \code{method.args} in \link[numDeriv]{grad} for more details.
  \item \strong{\code{scaleBeta}}: Logical. If TRUE (default), parameters are scaled by their own value before calculating the Hessian to increase numerical stability. However, the output is de-scaled, so they are in the same scale as the \code{apollo_beta} argument.
}}
}
\value{
List with the following elements
        \itemize{
          \item \strong{\code{apollo_beta}}: Named numerical vector. Parameter estimates (\code{model$estimate}, not scaled).
          \item \strong{\code{corrmat}}: Numerical matrix. Correlation between parameter estimates.
          \item \strong{\code{hessian}}: Numerical matrix. Hessian of the model at parameter estimates (\code{model$estimate}).
          \item \strong{\code{hessianScaling}}: Named numeric vector. Scales used on the paramaters to calculate the Hessian (non-fixed only).
          \item \strong{\code{methodsAttempted}}: Character vector. Name of methods attempted to calculate the Hessian.
          \item \strong{\code{methodUsed}}: Character. Name of method used to calculate the Hessian.
          \item \strong{\code{robcorrmat}}: Numerical matrix. Robust correlation between parameter estimates.
          \item \strong{\code{robse}}: Named numerical vector. Robust standard errors of parameter estimates.
          \item \strong{\code{robvarcov}}: Numerical matrix. Robust variance-covariance matrix.
          \item \strong{\code{se}}: Named numerical vector. Standard errors of parameter estimates.
          \item \strong{\code{varcov}}: Numerical matrix. Variance-covariance matrix.
        }
}
\description{
Calculates the Hessian, variance-covariance matrix and standard errors of an Apollo model as defined by its likelihood function 
and \code{apollo_inputs} list of settings. Performs automatic scaling for increased numeric stability.
}
\details{
It calculates the Hessian, variance-covariance, and standard errors at \code{apollo_beta} values of an 
estimated model. At least one of the following settings must be provided (ordered by speed of computation): \code{apollo_grad}, 
\code{apollo_logLike}, or (\code{apollo_probabilities} and \code{apollo_inputs}). If more than one is provided, 
then the priority is: \code{apollo_grad}, \code{apollo_logLike}, (\code{apollo_probabilities} and \code{apollo_inputs}).
}
