% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apexcharter.R
\name{apexcharter-shiny}
\alias{apexcharter-shiny}
\alias{apexchartOutput}
\alias{renderApexchart}
\title{Shiny bindings for apexcharter}
\usage{
apexchartOutput(outputId, width = "100\%", height = "400px")

renderApexchart(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a apexcharter}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An Apexchart output that can be included in the application UI.
}
\description{
Output and render functions for using apexcharter within Shiny
applications and interactive Rmd documents.
}
\examples{
if (interactive()) {
  library(shiny)
  library(apexcharter)
  
  ui <- fluidPage(
    fluidRow(
      column(
        width = 8, offset = 2,
        tags$h2("Apexchart in Shiny"),
        actionButton("redraw", "Redraw chart"),
        apexchartOutput("chart")
      )
    )
  )
  
  server <- function(input, output, session) {
    
    output$chart <- renderApexchart({
      input$redraw
      apexchart() \%>\%
        ax_chart(type = "bar") \%>\%
        ax_series(
          list(
            name = "Example",
            data = sample(1:100, 5)
          )
        ) \%>\%
        ax_xaxis(
          categories = LETTERS[1:5]
        )
    })
    
  }
  
  shinyApp(ui, server)
}
}
