context("read_access")


### expected behavior ----------------
  test_that("read_access expected behavior", {

    # whole file
    # testthat::expect_output(object = read_access(city='nat', year=2019))
    # testthat::expect_output(object = read_access(city='nat', geometry = TRUE))

    expect_true(is(  read_access(city='nat', geometry = TRUE), 'sf'))
    expect_true(is(  read_access(city='nat', geometry = FALSE), 'data.frame'))
    expect_true(is(  read_access(city='nat', geometry = FALSE, peak=FALSE), 'data.frame'))
    expect_true(is(  read_access(city='nat', geometry = FALSE, peak=FALSE, showProgress = FALSE), 'data.frame'))
  })


test_that("read_access expected behavior multiple cities", {

  # whole file
  # testthat::expect_output(object = read_access(city='nat', year=2019))
  # testthat::expect_output(object = read_access(city='nat', geometry = TRUE))

  test_walk <- read_access(city=c('nat', 'for'), mode= 'walk', geometry = FALSE)
  test_walk <- subset(test_walk, !is.na(mode))
  expect_true(is(  test_walk, 'data.frame'))
  expect_equal(  length(unique(test_walk$abbrev_muni)) , 2)
  expect_equal(  unique(test_walk$mode) , 'walk')


  test_pt <- read_access(city=c('rec', 'for'), mode= 'public_transport', geometry = FALSE)
  test_pt <- subset(test_pt, !is.na(mode))
  expect_true(is(  test_pt, 'data.frame'))
  expect_equal(  length(unique(test_pt$abbrev_muni)) , 2)
  expect_equal(  unique(test_pt$mode) , 'public_transport')


})



### expected errors and messages ----------------

test_that("read_access errors and messages", {

  # Wrong city
  testthat::expect_error(read_access(city = 'abcdefg'))
  testthat::expect_error(read_access(city = 'abc'))
  testthat::expect_error(read_access())

  # Wrong year
  testthat::expect_error(read_access(city = 'nat', year=1500))

   # Wrong mode
   testthat::expect_error( read_access(city=c('nat', 'for'), mode= 'public_transport', geometry = FALSE) )
   testthat::expect_error( read_access(city='nat', mode= 'public_transport', geometry = FALSE) )

    # Wrong geometry, peak, showProgress
   testthat::expect_error(read_access(city = 'nat', year=2019, geometry = 'aaa'))
   testthat::expect_error(read_access(city = 'nat', year=2019, showProgress = 'aaa'))
   testthat::expect_error(read_access(city = 'nat', year=2019, peak = 'aaa'))

})
