% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVMethods.R
\docType{methods}
\name{CV-Methods}
\alias{CV-Methods}
\alias{CV-methods}
\alias{CV}
\alias{CV,ANY-method}
\alias{CV,AIDS-method}
\alias{CV,CES-method}
\alias{CV,CESNests-method}
\alias{CV,Linear-method}
\alias{CV,LogLin-method}
\alias{CV,Logit-method}
\alias{CV,LogitNests-method}
\alias{CV,Auction2ndLogit-method}
\alias{CV,Cournot-method}
\title{Methods For Calculating Compensating Variation (CV)}
\usage{
\S4method{CV}{Cournot}(object)

\S4method{CV}{Linear}(object)

\S4method{CV}{Logit}(object)

\S4method{CV}{LogLin}(object)

\S4method{CV}{AIDS}(object)

\S4method{CV}{LogitNests}(object)

\S4method{CV}{Auction2ndLogit}(object)

\S4method{CV}{CES}(object)

\S4method{CV}{CESNests}(object)
}
\arguments{
\item{object}{An instance of one of the classes listed above.}
}
\description{
Calculate the amount of money a consumer would need to
be paid to be just as well off as they were before the merger.

All the information needed to
compute CV is already available within the Logit, Nested Logit CES and Nested CES classes.
In CES and Nested CES, CV cannot be calculated if the outside share cannot be inferred.

For AIDS, if the  \sQuote{insideSize}  slot to the \dQuote{AIDS} class equals NA, CV is calculated as a percentage of
total expenditure (revenues) on products included in the simulation. Otherwise CV is calculated in terms of dollars.
Pre-merger prices for all products in the market must be supplied in order for CV to be calculated.

For Linear and LogLin, although no additional information is needed to calculate CV for
either the \dQuote{Linear} or \dQuote{LogLin} classes, The CV method will fail if
the appropriate restrictions on the demand parameters have not been imposed.
}
\keyword{methods}
