% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{anthro_api_compute_prevalence}
\alias{anthro_api_compute_prevalence}
\title{Compute prevalence of zscores}
\usage{
anthro_api_compute_prevalence(data, zscores_to_compute, survey_subsets)
}
\arguments{
\item{data}{a data frame containing the underlying data}

\item{zscores_to_compute}{a list of zscore indicators that should be computed.
The list needs to have 4 named values:
\describe{
  \item{name}{The name or abbreviation of the indicator.
  This will appear in the column names of the output.}
  \item{column}{The column name without the 'z' of the zscore that shall be
  used.}
  \item{with_cutoffs}{TRUE iff cutoffs for the indicator shall be computed.}
  \item{with_auxiliary_zscore_column}{TRUE iff z-score should be set to
  -3.1 if \code{oedema = "y"} for prevalence estimates.}
  \item{auxiliary_zscore_condition}{optional function to define a special
  condition when the z-score should be set to -3.1}
}}

\item{survey_subsets}{subsets for which the prevalence values should be
computed. It is a named list of characters, where the values correspond
to columns and the names to labels in the output.}
}
\description{
Compute prevalence of zscores
}
\note{
This function is meant to be used by other anthro related packages.
It is not advised to use this in you own packages or analysis. If you must
use it, prepare for potential breaking changes in the future.
}
