/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.EntityDescriptor;
import weblogic.ejbc;

public final class EjbcHelper {
    private File descriptorDirectory;
    private File generatedFilesDirectory;
    private File manifestFile;
    private File sourceDirectory;
    String[] descriptors;
    private boolean keepGenerated;

    public static void main(String[] args) throws Exception {
        EjbcHelper helper = new EjbcHelper(args);
        helper.process();
    }

    private EjbcHelper(String[] args) {
        int index = 0;
        this.descriptorDirectory = new File(args[index++]);
        this.generatedFilesDirectory = new File(args[index++]);
        this.sourceDirectory = new File(args[index++]);
        this.manifestFile = new File(args[index++]);
        this.keepGenerated = Boolean.valueOf(args[index++]);
        this.descriptors = new String[args.length - index];
        int i = 0;
        while (index < args.length) {
            this.descriptors[i] = args[index++];
            ++i;
        }
    }

    private String[] getCommandLine(boolean debug, File descriptorFile) {
        Vector<String> v = new Vector<String>();
        if (!debug) {
            v.addElement("-noexit");
        }
        if (this.keepGenerated) {
            v.addElement("-keepgenerated");
        }
        v.addElement("-d");
        v.addElement(this.generatedFilesDirectory.getPath());
        v.addElement(descriptorFile.getPath());
        Object[] args = new String[v.size()];
        v.copyInto(args);
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRegenRequired(File descriptorFile) throws IOException {
        FileInputStream fis;
        block14: {
            boolean bl;
            block15: {
                boolean bl2;
                block13: {
                    boolean bl3;
                    block12: {
                        fis = null;
                        try {
                            try {
                                fis = new FileInputStream(descriptorFile);
                                ObjectInputStream ois = new ObjectInputStream(fis);
                                DeploymentDescriptor dd = (DeploymentDescriptor)ois.readObject();
                                fis.close();
                                String homeInterfacePath = dd.getHomeInterfaceClassName().replace('.', '/') + ".java";
                                String remoteInterfacePath = dd.getRemoteInterfaceClassName().replace('.', '/') + ".java";
                                String primaryKeyClassPath = null;
                                if (dd instanceof EntityDescriptor) {
                                    primaryKeyClassPath = ((EntityDescriptor)dd).getPrimaryKeyClassName();
                                    primaryKeyClassPath = primaryKeyClassPath.replace('.', '/') + ".java";
                                }
                                File homeInterfaceSource = new File(this.sourceDirectory, homeInterfacePath);
                                File remoteInterfaceSource = new File(this.sourceDirectory, remoteInterfacePath);
                                File primaryKeyClassSource = null;
                                if (primaryKeyClassPath != null) {
                                    primaryKeyClassSource = new File(this.sourceDirectory, remoteInterfacePath);
                                }
                                String beanClassBase = dd.getEnterpriseBeanClassName().replace('.', '/');
                                File ejbImplentationClass = new File(this.generatedFilesDirectory, beanClassBase + "EOImpl.class");
                                File homeImplementationClass = new File(this.generatedFilesDirectory, beanClassBase + "HomeImpl.class");
                                File beanStubClass = new File(this.generatedFilesDirectory, beanClassBase + "EOImpl_WLStub.class");
                                if (!(ejbImplentationClass.exists() && homeImplementationClass.exists() && beanStubClass.exists())) {
                                    bl3 = true;
                                    Object var19_19 = null;
                                    if (fis == null) return bl3;
                                    break block12;
                                }
                                long classModificationTime = ejbImplentationClass.lastModified();
                                if (homeImplementationClass.lastModified() < classModificationTime) {
                                    classModificationTime = homeImplementationClass.lastModified();
                                }
                                if (beanStubClass.lastModified() < classModificationTime) {
                                    classModificationTime = beanStubClass.lastModified();
                                }
                                if (descriptorFile.lastModified() > classModificationTime || homeInterfaceSource.lastModified() > classModificationTime || remoteInterfaceSource.lastModified() > classModificationTime) {
                                    bl2 = true;
                                    break block13;
                                }
                                if (primaryKeyClassSource == null || primaryKeyClassSource.lastModified() <= classModificationTime) break block14;
                                bl = true;
                                break block15;
                            }
                            catch (Throwable descriptorLoadException) {
                                System.out.println("Exception occurred reading " + descriptorFile.getName() + " - continuing");
                                boolean bl4 = true;
                                Object var19_23 = null;
                                if (fis == null) return bl4;
                                fis.close();
                                return bl4;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var19_24 = null;
                            if (fis == null) throw throwable;
                            fis.close();
                            throw throwable;
                        }
                    }
                    fis.close();
                    return bl3;
                }
                Object var19_20 = null;
                if (fis == null) return bl2;
                fis.close();
                return bl2;
            }
            Object var19_21 = null;
            if (fis == null) return bl;
            fis.close();
            return bl;
        }
        Object var19_22 = null;
        if (fis == null) return false;
        fis.close();
        return false;
    }

    private void process() throws Exception {
        String manifest = "Manifest-Version: 1.0\n\n";
        for (int i = 0; i < this.descriptors.length; ++i) {
            String descriptorName = this.descriptors[i];
            File descriptorFile = new File(this.descriptorDirectory, descriptorName);
            if (this.isRegenRequired(descriptorFile)) {
                System.out.println("Running ejbc for " + descriptorFile.getName());
                this.regenerateSupportClasses(descriptorFile);
            } else {
                System.out.println(descriptorFile.getName() + " is up to date");
            }
            manifest = manifest + "Name: " + descriptorName.replace('\\', '/') + "\nEnterprise-Bean: True\n\n";
        }
        FileWriter fw = new FileWriter(this.manifestFile);
        PrintWriter pw = new PrintWriter(fw);
        pw.print(manifest);
        fw.flush();
        fw.close();
    }

    private void regenerateSupportClasses(File descriptorFile) throws Exception {
        String[] args = this.getCommandLine(false, descriptorFile);
        try {
            ejbc.main((String[])args);
        }
        catch (Exception e) {
            String[] newArgs = this.getCommandLine(true, descriptorFile);
            ejbc.main((String[])newArgs);
        }
    }
}

