% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anocva.R
\name{checkRange01}
\alias{checkRange01}
\title{Check for {0,1} Interval Normalization.}
\usage{
checkRange01(data)
}
\arguments{
\item{data}{A matrix of data}
}
\value{
The data matrix normalized in the range {0,1}.
}
\description{
Verifies if the data is normalized in the range {0,1}.
If they are not, the normalization is performed and a warning issued.
}
\examples{
set.seed(2000)

simuData = runif(100, min = 0.5, max=7)
sprintf("The minimum value is \%.2f and the maximum is \%.2f.", min(simuData), max(simuData))

simuData = checkRange01(simuData)
sprintf("Now the minimum value is \%.2f and the maximum is \%.2f.", min(simuData), max(simuData))

}

