% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{sqlite2sql}
\alias{sqlite2sql}
\title{Function to dump sqlite database (Now only use system version sqlite)}
\usage{
sqlite2sql(sqlite_bin = c(Sys.which("sqlite"), Sys.which("sqlite3")),
  dbname = "", out.sql = "",
  cmd = "{sqlite_bin} {dbname} '.dump' | gzip > {out.sql}", debug = FALSE,
  ...)
}
\arguments{
\item{sqlite_bin}{Sqlite executable file}

\item{dbname}{Sqlite database path}

\item{out.sql}{Output SQL (gzip format)}

\item{cmd}{The command be used to dump}

\item{debug}{If set TRUE, only print the command}

\item{...}{Other parameters pass to \code{\link[base]{system}}}
}
\description{
Function to dump sqlite database (Now only use system version sqlite)
}
\examples{
sqlite2sql('sqlite3', 'default.sqlite', debug = TRUE)
}
