% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{annotation.region.match}
\alias{annotation.region.match}
\title{A regeion annotation utils that can be used to write a yourself annotation function}
\usage{
annotation.region.match(dat = data.table(), anno.name = "",
  buildver = "hg19", database.dir = Sys.getenv("annovarR_DB_DIR", ""),
  db.col.order = 1:3, index.cols = c("chr", "start", "end"),
  full.matched.cols = "chr", inferior.col = "start", superior.col = "end",
  return.col.index = 4, return.col.names = "",
  return.col.names.profix = "", format.dat.fun = format.cols,
  dbname.fixed = NULL, table.name.fixed = NULL, setdb.fun = set.db,
  set.table.fun = set.table, format.db.tb.fun = format.db.region.tb,
  db.type = "sqlite", db.file.prefix = NULL,
  mysql.connect.params = list(), sqlite.connect.params = list(),
  fread.db.params = list(), verbose = FALSE)
}
\arguments{
\item{dat}{A data.table including all of your data, eg. data.table(chr=c(1,2,3), start=c(1111,1112,1113))}

\item{anno.name}{Annotation name, eg. avsnp138, avsnp147, 1000g2015aug_all}

\item{buildver}{Genome version, hg19, hg38, mm10 and others}

\item{database.dir}{Dir of the databases (mysql no need)}

\item{db.col.order}{Using the index, you can rename the database table, and can be matched using matched.cols.}

\item{index.cols}{Using the selected cols to match data with sqlite database. eg. c('chr', 'start'), 'rs'}

\item{full.matched.cols}{Using the selected cols to match data with selected partial data by index.cols limited.}

\item{inferior.col}{Inferior limit col, e.g. start}

\item{superior.col}{Superior limit col, e.g. end}

\item{return.col.index}{Setting the colnums need be returned}

\item{return.col.names}{Setting the returned colnum names}

\item{return.col.names.profix}{Setting the returned colnum names profix}

\item{format.dat.fun}{A function to process input data. eg. as.numeric(dat$start); as.character(dat$chr)}

\item{dbname.fixed}{Database path (txt, sqlite) or name (MySQL), default is NULL, and get from setdb.fun 
(Set value will fix the dbname, and will be added in sqlite.connenct.params and mysql.connect.params)}

\item{table.name.fixed}{Table name, default is NULL, and get from set.table.fun (Set value will fix the table.name)
(Set value will fix the table.name, and will be added in sqlite.connenct.params and mysql.connect.params)}

\item{setdb.fun}{A function to process the name, buildver, database.dir and get the database path (MySQL return NULL)}

\item{set.table.fun}{A function to process the name, buildver and get the final table name}

\item{format.db.tb.fun}{A function to process the selected database table that can be used to matched with your data}

\item{db.type}{Setting the database type (sqlite, txt or mysql)}

\item{db.file.prefix}{Only be setted when db.type is local databae like sqlite or txt}

\item{mysql.connect.params}{Connect MySQL database other parameters, 
e.g. list(host='11.11.11.1', port = '3306', user = '', password = '123456')}

\item{sqlite.connect.params}{Connect SqLite database other paramertes, default is not need}

\item{fread.db.params}{For text format database, you can use fread.db.params to control the fread behavior}

\item{verbose}{Logical indicating wheather print the extra log infomation}
}
\description{
A regeion annotation utils that can be used to write a yourself annotation function
}
\examples{
library(data.table)
bed.file <- system.file('extdata', 'demo/example.bed', package = 'annovarR')
bed.sqlite <- sprintf('\%s/\%s.sqlite', tempdir(), basename(bed.file))
connect.params <- list(dbname = bed.sqlite, table.name = 'bed')
sqlite.build(bed.file, connect.params)
chr <- c('chr10', 'chr1')
start <- c('100188904', '100185955')
end <- c('100188904', '100185955')
dat <- data.table(chr = chr, start = start, end = end)
\dontrun{
x <- annotation.region.match(dat = dat, database.dir = tempdir(),
dbname.fixed = bed.sqlite, table.name.fixed = 'bed', 
db.type = 'sqlite', format.dat.fun = function(...) {
params = list(...);return(params[[1]])})
}
file.remove(bed.sqlite)
}
