\name{ani.control}
\alias{ani.control}
\alias{checkargs}
\title{ Control the Behaviour of Animations and Validate Arguments}
\description{
  Various arguments that control the behaviour of the animation. 
}
\usage{
ani.control(saveANI = FALSE, interval = 1, nmax = 50, 
    width = 480, height = 480, ...)
checkargs(control, ...)
}
\arguments{
  \item{saveANI}{ logical. Should the animation frames be saved as png files while being displayed inside R? }
  \item{interval}{ a positive number to set the time interval of the animation (unit in seconds). }
  \item{nmax}{ maximum number of steps for a loop (e.g. iterations) to create animation frames. }
  \item{width}{width of PNG image frames (unit in px); see \code{\link[grDevices]{png}}}
  \item{height}{height of PNG image frames (unit in px); see \code{\link[grDevices]{png}}}
  \item{control}{ a list containing animation arguments (typically generated by \code{\link{ani.control}}) }
  \item{\dots}{ for \code{\link{ani.control}}: other controlling arguments; for \code{\link[animation:ani.control]{checkargs}}: controlling arguments not included in \code{control}. }
}

\value{
a list containing the options.
}
\author{ Yihui Xie }
\note{ 
Please note that \code{nmax} is usually equal to the number of animation frames (e.g. for \code{\link{brownian.motion}}) but not \emph{always}! The reason is that sometimes there are more than one frame recorded in a single step of a loop, for instance, there are 2 frames generated in each step of \code{\link{kmeans.ani}}, and 4 frames in \code{\link{knn.ani}}, etc. 

The function \code{\link[animation:ani.control]{checkargs}} is just for the convenience of writing functions in this package (check the validity of animation arguments); it is of no use to non-developers. 
}
\seealso{ It is used in many animation functions such as \code{\link{brownian.motion}}, \code{\link{boot.iid}}, \code{\link{buffon.needle}}, \code{\link{cv.ani}}, \code{\link{flip.coin}}, \code{\link{kmeans.ani}}, \code{\link{knn.ani}}, etc.}
\examples{
\dontrun{
 
ani.start() 
op = par(mar = c(3, 3, 2, 0.5), mgp = c(2, .5, 0), tcl = -0.3, 
    cex.axis = 0.8, cex.lab = 0.8, cex.main = 1) 
brownian.motion(control = ani.control(interval = 0.05, nmax = 100,
    height = 500, width = 600, saveANI = TRUE))
par(op) 
ani.stop() 

}
}
\keyword{ misc }

