% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_confidence_intervals.R
\name{global_width_CI}
\alias{global_width_CI}
\title{To obtain width of 95\% confidence intervals for global network metrics using bootstrapped versions at each level of sub-sampling}
\usage{
global_width_CI(
  network,
  n_versions = 100,
  seed = 12345,
  n.iter = 10,
  network_metrics_functions_list = c(edge_density = function(x) igraph::edge_density(x),
    diameter = function(x) igraph::diameter(x, weights = NA), transitivity = function(x)
    igraph::transitivity(x)),
  scaled_metrics = NULL
)
}
\arguments{
\item{network}{An igraph object}

\item{n_versions}{Number of bootstrapped versions to be used. (default = 100)}

\item{seed}{seed number}

\item{n.iter}{Number of iterations at each level. (default = 10)}

\item{network_metrics_functions_list}{A list consisting of function definitions of the global network metrics that the user wants to evaluate. Each element in the list should have an assigned name.
Default = c("edge_density" = function(x) igraph::edge_density(x), "diameter" = function(x) igraph::diameter(x, weights = NA), "transitivity" = function(x) igraph::transitivity(x))}

\item{scaled_metrics}{Optional. A vector subset of the names of functions in network_metrics_functions_list with the metrics that should be scaled. For example scaled_metrics = c("diameter")}
}
\value{
A matrix of class Width_CI_matrix containing width of Confidence Intervals where each row corresponds to the sub-sample size and columns correspond to the chosen network metric.
Sub-sample size values occur in multiples of 10 and range from 10 to maximum multiple of 10 less than or equal to the number of nodes in the network.
}
\description{
To obtain width of 95\% confidence intervals for global network metrics using bootstrapped versions at each level of sub-sampling
}
\examples{
\donttest{
data(elk_network_2010)
width_CI_elk <- global_width_CI(elk_network_2010, n_versions = 100)
plot(width_CI_elk)
}
}
