% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anglr-package.R
\docType{data}
\name{cst10}
\alias{cst10}
\title{Antarctic coastline}
\format{
An object of class \code{SpatialPolygonsDataFrame} with 372 rows and 2 columns.
}
\usage{
cst10
}
\description{
Antartica features and coastline, with somewhat spurious precision.
}
\details{
In sp format. Interesting for exploring precision issues with DEL0()
see issue 7.
}
\examples{
\donttest{
p <- PATH0(cst10)
# DEL0(p)  ## fails as does DEL0(cst10)
# fails at 14 and crashes R in DEL0() in R version 4.0.0 RC (2020-04-17 r78247) on
# windows
p$vertex$x_ <- signif(p$vertex$x_, 13)
p$vertex$y_ <- signif(p$vertex$y_, 13)
DEL0(p)

## compare 14993 unique vertices after rounding to
silicate::sc_vertex(p)     ## 21875

silicate::sc_vertex(cst10) ## 21875
}
}
\keyword{datasets}
