% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3d.R
\name{plot3d}
\alias{plot3d}
\alias{plot3d.TRI}
\alias{plot3d.TRI0}
\alias{plot3d.DEL}
\alias{plot3d.DEL0}
\alias{plot3d.QUAD}
\alias{plot3d.matrix}
\alias{plot3d.BasicRaster}
\alias{plot3d.sc}
\alias{plot3d.SC}
\alias{plot3d.SC0}
\alias{plot3d.PATH}
\alias{plot3d.sf}
\alias{plot3d.sfc}
\alias{plot3d.triangulation}
\alias{plot3d.Spatial}
\alias{plot3d.trip}
\alias{plot3d.ARC}
\title{3D object plot}
\usage{
\method{plot3d}{TRI}(x, ...)

\method{plot3d}{TRI0}(x, ...)

\method{plot3d}{DEL}(x, ...)

\method{plot3d}{DEL0}(x, ...)

\method{plot3d}{QUAD}(x, ...)

\method{plot3d}{matrix}(x, ...)

\method{plot3d}{BasicRaster}(x, ...)

\method{plot3d}{sc}(x, ...)

\method{plot3d}{SC}(x, ..., add = FALSE)

\method{plot3d}{SC0}(x, ..., add = FALSE)

\method{plot3d}{PATH}(x, ..., add = FALSE)

\method{plot3d}{sf}(x, ..., add = FALSE)

\method{plot3d}{sfc}(x, ..., add = FALSE)

\method{plot3d}{triangulation}(x, ..., add = FALSE)

\method{plot3d}{Spatial}(x, ..., add = FALSE)

\method{plot3d}{trip}(x, ..., add = FALSE)

\method{plot3d}{ARC}(x, ..., add = FALSE)
}
\arguments{
\item{x}{silicate model, SC, TRI, ARC, or PATH}

\item{...}{passed to material properties}

\item{add}{add to plot or not}
}
\value{
rgl shape3d types (note that "segment3d" is currently an imaginary
shape3d type)
}
\description{
This is the workhorse function for anglr, the idea is that just about
anything can be plotted in a 3D scene, polygons, lines, rasters, matrix.
These objects from sp, sf, raster, trip, and silicate should all work.
}
\details{
The function \code{\link[=plot3d]{plot3d()}} covers the full suite of plotting functions from
\code{\link[rgl:plot3d]{rgl::plot3d()}} for meshes, points, and lines. This main function includes the
family of \code{\link[=dot3d]{dot3d()}}, \code{\link[=wire3d]{wire3d()}}, and \code{\link[=persp3d]{persp3d()}} and each works with
matrix, raster, sf, sp, trip, RTriangle, and silicate models. Each of the
mesh-surface forms rely on \code{\link[=as.mesh3d]{as.mesh3d()}} conversion behind the scenes,
whereas \code{\link[=plot3d]{plot3d()}} for the linear types (sf, sp, trip, and from silicate SC,
SC0, PATH, PATH0, and ARC0) all are plotted using rgl segments without going
through a triangulated surface form. This reflects their underlying topology
when it comes to 3D visualization and analysis.

If the scene looks funny the aspect ratio might be poor, we've decided not to
automatically update this with normal plots, but running \code{auto_3d()} will
attempt to set a reasonable aspect ratio. It can also be used to set
exaggerations in different axes.

For SC edges are matched to their object/s. One object's properties is
applied as colour. If \code{color_} column is present on the data object table it
is used.

If the argument 'color' is used, this is passed down to the rgl plot function  -
and will be applied per primitive, not per silicate object. This provides flexibility
but does require knowledge of the underlying structures in use.
}
\examples{
library(silicate)
cad_tas$color_ <- rainbow(nrow(cad_tas))
x <- SC(cad_tas)
plot3d(x)

## plot3d anything
plot3d(volcano)
wire3d(volcano)
dot3d(volcano)

\donttest{
plot3d(cad_tas)
persp3d(cad_tas)
wire3d(cad_tas)
dot3d(cad_tas)
}
## add Z elevation to an sf polygon in a mesh
plot3d(copy_down(as.mesh3d(silicate::minimal_mesh), raster::raster(volcano)))

## but make it much more interesting
\donttest{
plot3d(copy_down(as.mesh3d(DEL(silicate::minimal_mesh, max_area = 0.0001)),
  raster::raster(-volcano)), col = c("black", "orange")); auto_3d()
wire3d(silicate::minimal_mesh)
}
}
\seealso{
\link{wire3d} \link{as.mesh3d} \link{persp3d} \link{dot3d} \link{shade3d}
}
