% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects.R
\name{project_create}
\alias{project_create}
\title{Create a project}
\usage{
project_create(name, purpose, description = NULL, environment = NULL,
  ...)
}
\arguments{
\item{name}{(character) Name of the project. required}

\item{purpose}{(character) The purpose of the project. The maximum length
is 255 characters. For examples of valid purposes, see the "Purposes"
section. required}

\item{description}{(character) The description of the project. The maximum
length is 255 characters. optional}

\item{environment}{(character) The environment of the project's resources.
optional}

\item{...}{Additional options passed down to \code{\link[httr]{POST}}}
}
\value{
A project object
}
\description{
Create a project
}
\section{Purposes}{

The purpose attribute can have one of the following values:
\itemize{
\item Just trying out DigitalOcean
\item Class project / Educational purposes
\item Website or blog
\item Web Application
\item Service or API
\item Mobile Application
\item Machine learning / AI / Data processing
\item IoT
\item Operational / Developer tooling
}

If specify another value for purpose, for example "your custom purpose",
your purpose will be stored as Other: your custom purpose
}

\section{Environments}{

The environment attribute must have one of the following values:
\itemize{
\item Development
\item Staging
\item Production
}

If another value is specified, a 400 Bad Request is returned.
}

\examples{
\dontrun{
project_create(name = "venus", purpose = "Web Application")
}
}
