% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{update_sl_distr}
\alias{update_sl_distr}
\alias{update_ta_distr}
\title{Update movement distributions}
\usage{
update_sl_distr(object, beta_sl = "sl_", beta_log_sl = "log_sl_", ...)

update_ta_distr(object, beta_cos_ta = "cos_ta_", ...)
}
\arguments{
\item{object}{\verb{[fit_clogit]} \cr A fitted iSSF model.}

\item{beta_sl}{\verb{[character]} \cr The name of the coefficient of the step length.}

\item{beta_log_sl}{\verb{[character]} \cr The name of the coefficient of the log of the step length.}

\item{...}{Further arguments, none implemented.}

\item{beta_cos_ta}{\verb{[character]} \cr The name of the coefficient of cosine of the turning angle.}
}
\value{
An \code{amt_distr} object, which consists of a list with the \code{name} of
the distribution and its parameters (saved in \code{params}).
}
\description{
Update tentative step length or turning angle distribution from a fitted iSSF.
}
\examples{

# Fit an SSF, then update movement parameters.

 #Prepare data for SSF
ssf_data <- deer \%>\%
  steps_by_burst() \%>\%
  random_steps(n = 15) \%>\%
  extract_covariates(sh_forest) \%>\%
  mutate(forest = factor(sh.forest, levels = 1:2,
                    labels = c("forest", "non-forest")),
  cos_ta_ = cos(ta_),
  log_sl_ = log(sl_))

# Check tentative distributions
#    Step length
attr(ssf_data, "sl_")
#    Turning angle
attr(ssf_data, "ta_")

# Fit an iSSF
m1 <- ssf_data \%>\%
  fit_issf(case_ ~ forest +
               sl_ + log_sl_ + cos_ta_ +
               strata(step_id_))

# Update step length distribution
new_gamma <- update_sl_distr(m1)

#Update turning angle distribution
new_vm <- update_ta_distr(m1)

}
\references{
Fieberg et al. in prep.
}
\seealso{
Wrapper to fit a distribution to data \code{\link{fit_distr}()}
}
\author{
Brian J. Smith
}
