% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMPD.r
\name{AMPD}
\alias{AMPD}
\title{AMPD}
\usage{
AMPD(data, L, plotting = FALSE)
}
\arguments{
\item{data}{list containing noisy data}

\item{L, }{maximum number of scales (corresponding tothe maximum width of the window used)}

\item{plotting}{default FALSE, plots useful information if TRUE}
}
\value{
A list with different variables: LMS ($LMS), rescaled LMS ($rLMS), position of global minimum of the row-wise summation of LMS ($minLoc), position of maxima ($maximaLoc)
}
\description{
Implementation of the automatic multiscale-based peak detection (AMPD) algorithm.
AMPD enables to detect peaks in noisy periodic and quasi-periodic signals
}
\examples{
t = seq(0,2,0.005)
data = sin(25*t)*sin(0.3*t)+0.4*t
dataNoise = jitter(data,1000)
returnedList = AMPD(dataNoise,200,TRUE)
returnedList$maximaLoc
}
\references{
Scholkmann et al. (2012). An Efficient Algorithm for Automatic Peak Detection in Noisy Periodic and Quasi-Periodic Signals. Algorithms, 5 (4), 588-603 http://www.mdpi.com/1999-4893/5/4/588
}
\keyword{detection}
\keyword{peak}

