% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/router.R
\name{Router}
\alias{Router}
\title{Router}
\description{
Web server.
}
\examples{
# log
logger <- new_log()
# router
# create router
router <- Router$new("/users")

router$get("/", function(req, res){
 res$send("List of users")
})

router$get("/:id", function(req, res){
 logger$log("Return user id:", req$params$id)
 res$send(req$params$id)
})

router$get("/:id/profile", function(req, res){
 msg <- sprintf("This is the profile of user #\%s", req$params$id)
 res$send(msg)
})

# core app
app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Home!")
})

# mount the router
app$use(router)

if(interactive())
 app$start()

}
\section{Super class}{
\code{\link[ambiorix:Routing]{ambiorix::Routing}} -> \code{Router}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{error}}{500 response when the route errors, must a handler function that accepts the request and the response, by default uses \code{\link[=response_500]{response_500()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Router$new()}}
\item \href{#method-print}{\code{Router$print()}}
\item \href{#method-clone}{\code{Router$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="all">}\href{../../ambiorix/html/Routing.html#method-all}{\code{ambiorix::Routing$all()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="delete">}\href{../../ambiorix/html/Routing.html#method-delete}{\code{ambiorix::Routing$delete()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get">}\href{../../ambiorix/html/Routing.html#method-get}{\code{ambiorix::Routing$get()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get_middleware">}\href{../../ambiorix/html/Routing.html#method-get_middleware}{\code{ambiorix::Routing$get_middleware()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get_receivers">}\href{../../ambiorix/html/Routing.html#method-get_receivers}{\code{ambiorix::Routing$get_receivers()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get_routes">}\href{../../ambiorix/html/Routing.html#method-get_routes}{\code{ambiorix::Routing$get_routes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="options">}\href{../../ambiorix/html/Routing.html#method-options}{\code{ambiorix::Routing$options()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="patch">}\href{../../ambiorix/html/Routing.html#method-patch}{\code{ambiorix::Routing$patch()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="post">}\href{../../ambiorix/html/Routing.html#method-post}{\code{ambiorix::Routing$post()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="put">}\href{../../ambiorix/html/Routing.html#method-put}{\code{ambiorix::Routing$put()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="receive">}\href{../../ambiorix/html/Routing.html#method-receive}{\code{ambiorix::Routing$receive()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="use">}\href{../../ambiorix/html/Routing.html#method-use}{\code{ambiorix::Routing$use()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$new(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The base path of the router.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define the base route.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
