% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amanida_vote.R
\name{amanida_vote}
\alias{amanida_vote}
\title{Qualitative meta-analysis}
\usage{
amanida_vote(data)
}
\arguments{
\item{data}{data imported using \code{amanida_read} function w/o names checked by \code{check_names}}
}
\value{
METAtable S4 object with vote-counting for each compound on @slot vote
}
\description{
\code{amanida_vote} performs vote-counting on qualitative data.
}
\details{
Vote-counting is computed without trend division. Punctuation of entries is based on trend, up-regulation gives 1, down-regulation give -1 and equal behavior gives 0. Total sum is divided then by the total number of entries on each compound. Compound combination is made with PubChem CID when is available.

Note that \code{amanida_vote} skips rows with missing values or NA.

Formats compatible are csv, xlsx, xls or txt.
}
\examples{
\dontrun{
coln = c("Compound Name", "Behaviour", "References")
input_file <- system.file("extdata", "dataset2.csv", package = "amanida")
data_votes <- amanida_read(input_file, mode = "qual", coln, separator = ";")

vote_result <- amanida_vote(data_votes)
}

}
