# docsify: main files are correct

    Code
      .readlines("docs/README.md")
    Output
       [1] ""                                                                                                  
       [2] "<!-- README.md is generated from README.Rmd. Please edit that file -->"                            
       [3] ""                                                                                                  
       [4] "# testpkg.altdoc"                                                                                  
       [5] ""                                                                                                  
       [6] "<!-- badges: start -->"                                                                            
       [7] ""                                                                                                  
       [8] "[![R-universe status"                                                                              
       [9] "badge](https://grantmcdermott.r-universe.dev/badges/plot2)](https://grantmcdermott.r-universe.dev)"
      [10] "<!-- badges: end -->"                                                                              
      [11] ""                                                                                                  
      [12] "The goal of testpkg.altdoc is to …"                                                                
      [13] ""                                                                                                  
      [14] "## Installation"                                                                                   
      [15] ""                                                                                                  
      [16] "You can install the development version of testpkg.altdoc like so:"                                
      [17] ""                                                                                                  
      [18] "``` r"                                                                                             
      [19] "# FILL THIS IN! HOW CAN PEOPLE INSTALL YOUR DEV PACKAGE?"                                          
      [20] "```"                                                                                               
      [21] ""                                                                                                  
      [22] "## Example"                                                                                        
      [23] ""                                                                                                  
      [24] "This is a basic example which shows you how to solve a common problem:"                            
      [25] ""                                                                                                  
      [26] "``` r"                                                                                             
      [27] "library(testpkg.altdoc)"                                                                           
      [28] "summary(cars)"                                                                                     
      [29] "#>      speed           dist       "                                                               
      [30] "#>  Min.   : 4.0   Min.   :  2.00  "                                                               
      [31] "#>  1st Qu.:12.0   1st Qu.: 26.00  "                                                               
      [32] "#>  Median :15.0   Median : 36.00  "                                                               
      [33] "#>  Mean   :15.4   Mean   : 42.98  "                                                               
      [34] "#>  3rd Qu.:19.0   3rd Qu.: 56.00  "                                                               
      [35] "#>  Max.   :25.0   Max.   :120.00"                                                                 
      [36] "```"                                                                                               

---

    Code
      .readlines("docs/_sidebar.md")
    Output
       [1] "* [Home](/)"                                 
       [2] "* Articles: "                                
       [3] "  - [here.pdf](vignettes/here.pdf ':ignore')"
       [4] "  - [test](vignettes/test.md)"               
       [5] "* Reference: "                               
       [6] "  - [examplesIf_false](man/examplesIf_false)"
       [7] "  - [examplesIf_true](man/examplesIf_true)"  
       [8] "  - [hello_base](man/hello_base)"            
       [9] "  - [hello_r6](man/hello_r6)"                
      [10] "* [News](NEWS.md)"                           
      [11] "* [Citation](CITATION.md)"                   

---

    Code
      .readlines("docs/index.html")
    Output
       [1] "<!-- index.html -->"                                                                                                                                                                              
       [2] ""                                                                                                                                                                                                 
       [3] "<!DOCTYPE html>"                                                                                                                                                                                  
       [4] "<html>"                                                                                                                                                                                           
       [5] "<head>"                                                                                                                                                                                           
       [6] "  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">"                                                                                                                             
       [7] "  <meta name=\"viewport\" content=\"width=device-width,initial-scale=1\">"                                                                                                                        
       [8] "  <meta charset=\"UTF-8\">"                                                                                                                                                                       
       [9] "  <link rel=\"stylesheet\" href=\"//cdn.jsdelivr.net/npm/docsify@4/themes/vue.css\" />"                                                                                                           
      [10] "</head>"                                                                                                                                                                                          
      [11] "<body>"                                                                                                                                                                                           
      [12] "  <div id=\"app\"></div>"                                                                                                                                                                         
      [13] "  <script>"                                                                                                                                                                                       
      [14] "    window.$docsify = {"                                                                                                                                                                          
      [15] "      name: 'testpkg.altdoc',"                                                                                                                                                                    
      [16] "      repo: 'https://github.com/etiennebacher/altdoc',"                                                                                                                                           
      [17] "      loadSidebar: true,"                                                                                                                                                                         
      [18] "      subMaxLevel: 2,"                                                                                                                                                                            
      [19] "      search: {"                                                                                                                                                                                  
      [20] "        placeholder: 'Search',"                                                                                                                                                                   
      [21] "        depth: 3,"                                                                                                                                                                                
      [22] "      },"                                                                                                                                                                                         
      [23] "      auto2top: true,"                                                                                                                                                                            
      [24] "      copyCode: {"                                                                                                                                                                                
      [25] "        buttonText : 'Copy',"                                                                                                                                                                     
      [26] "        errorText  : 'Error',"                                                                                                                                                                    
      [27] "        successText: 'Copied'"                                                                                                                                                                    
      [28] "      },"                                                                                                                                                                                         
      [29] "      plugins: ["                                                                                                                                                                                 
      [30] "        function(hook) {"                                                                                                                                                                         
      [31] "          var footer = [\"<a > <code> testpkg.altdoc </code> v. 0.1.0 </a> | Documentation made with <a href='https://altdoc.etiennebacher.com/'> <code> altdoc </code> v. 0.6.0</a>\"].join('');"
      [32] ""                                                                                                                                                                                                 
      [33] "          hook.afterEach(function(html) {"                                                                                                                                                        
      [34] "            return html + footer;"                                                                                                                                                                
      [35] "          });"                                                                                                                                                                                    
      [36] "        }"                                                                                                                                                                                        
      [37] "      ]"                                                                                                                                                                                          
      [38] "    }"                                                                                                                                                                                            
      [39] "  </script>"                                                                                                                                                                                      
      [40] "  <script src=\"//cdn.jsdelivr.net/npm/docsify@4\"></script>"                                                                                                                                     
      [41] "  <script src=\"//cdn.jsdelivr.net/npm/docsify-copy-code\"></script>"                                                                                                                             
      [42] "  <script src=\"//cdn.jsdelivr.net/npm/prismjs@1.24.1/components/prism-r.js\"></script>"                                                                                                          
      [43] "  <script src=\"//unpkg.com/docsify/lib/plugins/search.min.js\"></script>"                                                                                                                        
      [44] "</body>"                                                                                                                                                                                          
      [45] "</html>"                                                                                                                                                                                          

---

    Code
      .readlines("docs/NEWS.md")
    Output
      [1] "# foobar 1.1.0"                                                                                                                     
      [2] ""                                                                                                                                   
      [3] "* thanks [@foo-bar](https://github.com/foo-bar) for their contribution ([#111](https://github.com/etiennebacher/altdoc/issues/111))"
      [4] ""                                                                                                                                   
      [5] "* thanks [@foo2-](https://github.com/foo2-) for their contribution ([#11](https://github.com/etiennebacher/altdoc/issues/11))"      
      [6] ""                                                                                                                                   
      [7] "* thanks [@JohnDoe](https://github.com/JohnDoe), [@JaneDoe](https://github.com/JaneDoe)"                                            
      [8] ""                                                                                                                                   
      [9] "* this should not be linked: foo.bar@email.com"                                                                                     

---

    Code
      .readlines("docs/man/hello_base.md")
    Output
       [1] ""                                                                                 
       [2] ""                                                                                 
       [3] "# Base function"                                                                  
       [4] ""                                                                                 
       [5] "## Description"                                                                   
       [6] ""                                                                                 
       [7] "Base function"                                                                    
       [8] ""                                                                                 
       [9] "## Usage"                                                                         
      [10] ""                                                                                 
      [11] "<pre><code class='language-R'>hello_base(x = 2)"                                  
      [12] "</code></pre>"                                                                    
      [13] ""                                                                                 
      [14] "## Arguments"                                                                     
      [15] ""                                                                                 
      [16] "<table role=\"presentation\">"                                                    
      [17] "<tr>"                                                                             
      [18] "<td style=\"white-space: collapse; font-family: monospace; vertical-align: top\">"
      [19] "<code id=\"x\">x</code>"                                                          
      [20] "</td>"                                                                            
      [21] "<td>"                                                                             
      [22] "A parameter"                                                                      
      [23] "</td>"                                                                            
      [24] "</tr>"                                                                            
      [25] "</table>"                                                                         
      [26] ""                                                                                 
      [27] "## Details"                                                                       
      [28] ""                                                                                 
      [29] "Some code with weird symbols: <code>pl$when(condition)</code> and"                
      [30] "<code>pl$then(output)</code>"                                                     
      [31] ""                                                                                 
      [32] "Some equations: ∂*Y*/∂*X* = *a* + *ε*/2"                                          
      [33] ""                                                                                 
      [34] "## Value"                                                                         
      [35] ""                                                                                 
      [36] "Some value"                                                                       
      [37] ""                                                                                 
      [38] "## References"                                                                    
      [39] ""                                                                                 
      [40] "Ihaka R, Gentleman R (1996). R: A Language for Data Analysis and"                 
      [41] "Graphics. <em>Journal of Computational and Graphical Statistics</em>."            
      [42] "<b>5</b>(3), 299–314."                                                            
      [43] "[doi:10.2307/139080](https://doi.org/10.2307/139080)"                             
      [44] ""                                                                                 
      [45] "## See Also"                                                                      
      [46] ""                                                                                 
      [47] "<code>print</code>, <code>hello_r6</code>"                                        
      [48] ""                                                                                 
      [49] "## Examples"                                                                      
      [50] ""                                                                                 
      [51] "``` r"                                                                            
      [52] "library(\"testpkg.altdoc\")"                                                      
      [53] ""                                                                                 
      [54] "hello_base()"                                                                     
      [55] "```"                                                                              
      [56] ""                                                                                 
      [57] "    [1] \"Hello, world!\""                                                        
      [58] ""                                                                                 
      [59] "``` r"                                                                            
      [60] "mtcars$drat <- mtcars$drat + 1"                                                   
      [61] "head(mtcars[[\"drat\"]], 2)"                                                      
      [62] "```"                                                                              
      [63] ""                                                                                 
      [64] "    [1] 4.9 4.9"                                                                  

---

    Code
      .readlines("docs/man/hello_r6.md")
    Output
        [1] ""                                                                     
        [2] ""                                                                     
        [3] "# Create a \"conductor\" tour"                                        
        [4] ""                                                                     
        [5] "## Description"                                                       
        [6] ""                                                                     
        [7] "blah blah blah"                                                       
        [8] ""                                                                     
        [9] "## Methods"                                                           
       [10] ""                                                                     
       [11] "<h4>"                                                                 
       [12] "Public methods"                                                       
       [13] "</h4>"                                                                
       [14] "<ul>"                                                                 
       [15] "<li>"                                                                 
       [16] ""                                                                     
       [17] "<a href=\"#method-Conductor-new\"><code>hello_r6$new()</code></a>"    
       [18] ""                                                                     
       [19] "</li>"                                                                
       [20] "<li>"                                                                 
       [21] ""                                                                     
       [22] "<a href=\"#method-Conductor-init\"><code>hello_r6$init()</code></a>"  
       [23] ""                                                                     
       [24] "</li>"                                                                
       [25] "<li>"                                                                 
       [26] ""                                                                     
       [27] "<a href=\"#method-Conductor-step\"><code>hello_r6$step()</code></a>"  
       [28] ""                                                                     
       [29] "</li>"                                                                
       [30] "<li>"                                                                 
       [31] ""                                                                     
       [32] "<a href=\"#method-Conductor-clone\"><code>hello_r6$clone()</code></a>"
       [33] ""                                                                     
       [34] "</li>"                                                                
       [35] "</ul>"                                                                
       [36] "<hr>"                                                                 
       [37] ""                                                                     
       [38] "<a id=\"method-Conductor-new\"></a>"                                  
       [39] ""                                                                     
       [40] "<h4>"                                                                 
       [41] "Method <code>new()</code>"                                            
       [42] "</h4>"                                                                
       [43] "<h5>"                                                                 
       [44] "Usage"                                                                
       [45] "</h5>"                                                                
       [46] ""                                                                     
       [47] "<pre>hello_r6\\$new()</pre>"                                          
       [48] ""                                                                     
       [49] "<h5>"                                                                 
       [50] "Details"                                                              
       [51] "</h5>"                                                                
       [52] ""                                                                     
       [53] "Initialise <code>Conductor</code>."                                   
       [54] ""                                                                     
       [55] "<hr>"                                                                 
       [56] ""                                                                     
       [57] "<a id=\"method-Conductor-init\"></a>"                                 
       [58] ""                                                                     
       [59] "<h4>"                                                                 
       [60] "Method <code>init()</code>"                                           
       [61] "</h4>"                                                                
       [62] "<h5>"                                                                 
       [63] "Usage"                                                                
       [64] "</h5>"                                                                
       [65] ""                                                                     
       [66] "<pre>hello_r6\\$init(session = NULL)</pre>"                           
       [67] ""                                                                     
       [68] "<h5>"                                                                 
       [69] "Arguments"                                                            
       [70] "</h5>"                                                                
       [71] ""                                                                     
       [72] "<dl>"                                                                 
       [73] "<dt>"                                                                 
       [74] "<code>session</code>"                                                 
       [75] "</dt>"                                                                
       [76] "<dd>"                                                                 
       [77] "A valid Shiny session. If <code>NULL</code> (default), the function"  
       [78] "attempts to get the session with"                                     
       [79] "<code>shiny::getDefaultReactiveDomain()</code>."                      
       [80] "</dd>"                                                                
       [81] "</dl>"                                                                
       [82] ""                                                                     
       [83] "<h5>"                                                                 
       [84] "Details"                                                              
       [85] "</h5>"                                                                
       [86] ""                                                                     
       [87] "Initialise <code>Conductor</code>."                                   
       [88] ""                                                                     
       [89] "<hr>"                                                                 
       [90] ""                                                                     
       [91] "<a id=\"method-Conductor-step\"></a>"                                 
       [92] ""                                                                     
       [93] "<h4>"                                                                 
       [94] "Method <code>step()</code>"                                           
       [95] "</h4>"                                                                
       [96] "<h5>"                                                                 
       [97] "Usage"                                                                
       [98] "</h5>"                                                                
       [99] ""                                                                     
      [100] "<pre>hello_r6\\$step(title = NULL)</pre>"                             
      [101] ""                                                                     
      [102] "<h5>"                                                                 
      [103] "Arguments"                                                            
      [104] "</h5>"                                                                
      [105] ""                                                                     
      [106] "<dl>"                                                                 
      [107] "<dt>"                                                                 
      [108] "<code>title</code>"                                                   
      [109] "</dt>"                                                                
      [110] "<dd>"                                                                 
      [111] "Title of the popover."                                                
      [112] "</dd>"                                                                
      [113] "</dl>"                                                                
      [114] ""                                                                     
      [115] "<h5>"                                                                 
      [116] "Details"                                                              
      [117] "</h5>"                                                                
      [118] ""                                                                     
      [119] "Add a step in a <code>Conductor</code> tour."                         
      [120] ""                                                                     
      [121] "<hr>"                                                                 
      [122] ""                                                                     
      [123] "<a id=\"method-Conductor-clone\"></a>"                                
      [124] ""                                                                     
      [125] "<h4>"                                                                 
      [126] "Method <code>clone()</code>"                                          
      [127] "</h4>"                                                                
      [128] ""                                                                     
      [129] "The objects of this class are cloneable with this method."            
      [130] ""                                                                     
      [131] "<h5>"                                                                 
      [132] "Usage"                                                                
      [133] "</h5>"                                                                
      [134] ""                                                                     
      [135] "<pre>hello_r6\\$clone(deep = FALSE)</pre>"                            
      [136] ""                                                                     
      [137] "<h5>"                                                                 
      [138] "Arguments"                                                            
      [139] "</h5>"                                                                
      [140] ""                                                                     
      [141] "<dl>"                                                                 
      [142] "<dt>"                                                                 
      [143] "<code>deep</code>"                                                    
      [144] "</dt>"                                                                
      [145] "<dd>"                                                                 
      [146] "Whether to make a deep clone."                                        
      [147] "</dd>"                                                                
      [148] "</dl>"                                                                

---

    Code
      .readlines("docs/man/examplesIf_true.md")
    Output
       [1] ""                                                                                 
       [2] ""                                                                                 
       [3] "# Examples If TRUE"                                                               
       [4] ""                                                                                 
       [5] "## Description"                                                                   
       [6] ""                                                                                 
       [7] "Examples If TRUE"                                                                 
       [8] ""                                                                                 
       [9] "## Usage"                                                                         
      [10] ""                                                                                 
      [11] "<pre><code class='language-R'>examplesIf_true()"                                  
      [12] "</code></pre>"                                                                    
      [13] ""                                                                                 
      [14] "## Arguments"                                                                     
      [15] ""                                                                                 
      [16] "<table role=\"presentation\">"                                                    
      [17] "<tr>"                                                                             
      [18] "<td style=\"white-space: collapse; font-family: monospace; vertical-align: top\">"
      [19] "<code id=\"x\">x</code>"                                                          
      [20] "</td>"                                                                            
      [21] "<td>"                                                                             
      [22] "A parameter"                                                                      
      [23] "</td>"                                                                            
      [24] "</tr>"                                                                            
      [25] "</table>"                                                                         
      [26] ""                                                                                 
      [27] "## Value"                                                                         
      [28] ""                                                                                 
      [29] "Some value"                                                                       
      [30] ""                                                                                 
      [31] "## Examples"                                                                      
      [32] ""                                                                                 
      [33] "``` r"                                                                            
      [34] "library(\"testpkg.altdoc\")"                                                      
      [35] ""                                                                                 
      [36] ""                                                                                 
      [37] "examplesIf_true()"                                                                
      [38] "```"                                                                              
      [39] ""                                                                                 
      [40] "    [1] \"Hello, world!\""                                                        

---

    Code
      .readlines("docs/man/examplesIf_false.md")
    Output
       [1] ""                                                                                 
       [2] ""                                                                                 
       [3] "# Examples If FALSE"                                                              
       [4] ""                                                                                 
       [5] "## Description"                                                                   
       [6] ""                                                                                 
       [7] "Examples If FALSE"                                                                
       [8] ""                                                                                 
       [9] "## Usage"                                                                         
      [10] ""                                                                                 
      [11] "<pre><code class='language-R'>examplesIf_false()"                                 
      [12] "</code></pre>"                                                                    
      [13] ""                                                                                 
      [14] "## Arguments"                                                                     
      [15] ""                                                                                 
      [16] "<table role=\"presentation\">"                                                    
      [17] "<tr>"                                                                             
      [18] "<td style=\"white-space: collapse; font-family: monospace; vertical-align: top\">"
      [19] "<code id=\"x\">x</code>"                                                          
      [20] "</td>"                                                                            
      [21] "<td>"                                                                             
      [22] "A parameter"                                                                      
      [23] "</td>"                                                                            
      [24] "</tr>"                                                                            
      [25] "</table>"                                                                         
      [26] ""                                                                                 
      [27] "## Value"                                                                         
      [28] ""                                                                                 
      [29] "Some value"                                                                       
      [30] ""                                                                                 
      [31] "## Examples"                                                                      
      [32] ""                                                                                 
      [33] "``` r"                                                                            
      [34] "library(\"testpkg.altdoc\")"                                                      
      [35] ""                                                                                 
      [36] ""                                                                                 
      [37] "examplesIf_false()"                                                               
      [38] "```"                                                                              

---

    Code
      .readlines("docs/vignettes/test.md")
    Output
      [1] "# test"                  ""                       
      [3] ""                        "``` r"                  
      [5] "library(testpkg.altdoc)" "```"                    
      [7] ""                        "hello there"            

