% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use.R
\name{use_docute}
\alias{use_docute}
\alias{use_docsify}
\alias{use_mkdocs}
\title{Init Docute, Docsify, or Mkdocs}
\usage{
use_docute(convert_vignettes = TRUE, overwrite = FALSE, path = ".")

use_docsify(convert_vignettes = TRUE, overwrite = FALSE, path = ".")

use_mkdocs(
  theme = NULL,
  convert_vignettes = TRUE,
  overwrite = FALSE,
  path = "."
)
}
\arguments{
\item{convert_vignettes}{Do you want to convert and import vignettes if you have
some? This will not modify files in the folder 'vignettes'. This feature
is experimental.}

\item{overwrite}{Overwrite the folder 'docs' if it already exists. If \code{FALSE}
(default), there will be an interactive choice to make in the console to
overwrite. If \code{TRUE}, the folder 'docs' is automatically overwritten.}

\item{path}{Path. Default is the package root (detected with \code{here::here()}).}

\item{theme}{Name of the theme to use. Default is basic theme. See Details
section.}
}
\value{
No value returned. Creates files in folder 'docs'. Other files and
folders are not modified.
}
\description{
Init Docute, Docsify, or Mkdocs
}
\details{
If you are new to Mkdocs, the themes "readthedocs" and "material" are among
the most popular and developed. You can also see a list of themes here: \url{https://github.com/mkdocs/mkdocs/wiki/MkDocs-Themes}.
}
\examples{
if (interactive()) {
# Create docute documentation
use_docute()

# Create docsify documentation
use_docsify()

# Create mkdocs documentation
use_mkdocs()
}
}
