% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biasCorr.R
\name{biasCorr}
\alias{biasCorr}
\title{Asymptotic bias-correction after fitting binary choice models with two-way error component}
\usage{
biasCorr(object = NULL, L = 0L)
}
\arguments{
\item{object}{an object of class \code{"feglm"}; currently restricted to \code{\link[stats]{binomial}} 
with \code{"logit"} or \code{"probit"} link function.}

\item{L}{unsigned integer indicating a bandwidth for the estimation of spectral densities proposed by 
Hahn and Kuersteiner (2011). Default is zero, which should be used if all regressors are 
assumed to be strictly exogenous. In the presence of weakly exogenous or predetermined 
regressors, Fernandez-Val and Weidner (2016, 2018) suggest to choose a bandwidth not higher than 
four.}
}
\value{
The function \code{\link{biasCorr}} returns a named list of classes \code{"biasCorr"} and 
\code{"feglm"}.
}
\description{
\code{\link{biasCorr}} is a post-estimation routine that can be used to substantially reduce the 
incidental parameter bias problem (Neyman and Scott (1948)) present in non-linear fixed effects 
models (see Fernandez-Val and Weidner (2018) for an overview). The command applies the analytical 
bias-correction derived by Fernandez-Val and Weinder (2016) to obtain bias-corrected estimates of 
the structural parameters and is currently restricted to logit and probit models.
}
\examples{
\donttest{
# Generate an artificial data set for logit models
library(alpaca)
data <- simGLM(1000L, 20L, 1805L, model = "logit")

# Fit 'feglm()'
mod <- feglm(y ~ x1 + x2 + x3 | i + t, data)

# Apply analytical bias-correction
mod.bc <- biasCorr(mod)
summary(mod.bc)

# Compute bias-corrected average partial effects
mod.ape <- getAPEs(mod.bc)
summary(mod.ape)
}
}
\references{
Czarnowske, D. and Stammann, A. (2019). "Binary Choice Models with High-Dimensional Individual 
and Time Fixed Effects". ArXiv e-prints.

Fernandez-Val, I. and Weidner, M. (2016). "Individual and time effects in nonlinear panel models 
with large N, T". Journal of Econometrics, 192(1), 291-312.

Fernandez-Val, I. and Weidner M. (2018). "Fixed effects estimation of large-t panel data models". 
Annual Review of Economics, 10, 109-138.

Hahn, J. and Kuersteiner, G. (2011). "Bias reduction for dynamic nonlinear panel models with 
fixed effects". Econometric Theory, 27(6), 1152-1191.

Neyman, J. and Scott, E. L. (1948). "Consistent estimates based on partially consistent 
observations". Econometrica, 16(1), 1-32.
}
\seealso{
\code{\link{feglm}}
}
