% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rescale.R
\docType{methods}
\name{rescale_area}
\alias{rescale_area}
\alias{rescale_area-method}
\alias{rescale_area,numeric,numeric-method}
\alias{rescale_area,ANY,missing-method}
\title{Normalize intensities by AUC}
\usage{
rescale_area(x, y, ...)

\S4method{rescale_area}{numeric,numeric}(x, y, method = c("rectangle", "trapezoid"), ...)

\S4method{rescale_area}{ANY,missing}(x, method = c("rectangle", "trapezoid"), ...)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{method}{A \code{\link{character}} string specifying the method for integration.
It must be one of "\code{rectangle}" or "\code{trapezoid}".
Any unambiguous substring can be given.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Rescales intensities so that the area under the curve (AUC) is equal to 1.
}
\examples{
## gamma-ray spectrometry
data("BEGe")

## Subset from 2.75 to 200 keV
BEGe <- signal_select(BEGe, from = 3, to = 200)

## Plot spectrum
plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")

## Normalize by area under the curve
BEGe_area <- rescale_area(BEGe)
plot(BEGe_area, type = "l", xlab = "Energy (keV)", ylab = "Count")
integrate_rectangle(BEGe)
integrate_rectangle(BEGe_area)

## Rescale so that intensities sum to 1
BEGe_total <- rescale_total(BEGe, total = 1)
plot(BEGe_total, type = "l", xlab = "Energy (keV)", ylab = "Count")

## Rescale intensities to 0-1
BEGe_range <- rescale_range(BEGe, min = 0, max = 1)
plot(BEGe_range, type = "l", xlab = "Energy (keV)", ylab = "Count")
}
\seealso{
Other normalization methods: 
\code{\link{rescale_range}()},
\code{\link{rescale_snv}()},
\code{\link{rescale_total}()},
\code{\link{rescale_transform}()}
}
\author{
N. Frerebeau
}
\concept{normalization methods}
