% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/baseline.R
\docType{methods}
\name{baseline_polynomial}
\alias{baseline_polynomial}
\alias{baseline_polynomial-method}
\alias{baseline_polynomial,numeric,numeric-method}
\alias{baseline_polynomial,ANY,missing-method}
\title{Polynomial Baseline Estimation}
\usage{
baseline_polynomial(x, y, ...)

\S4method{baseline_polynomial}{numeric,numeric}(x, y, d = 3, tolerance = 0.001, stop = 100)

\S4method{baseline_polynomial}{ANY,missing}(x, d = 3, tolerance = 0.001, stop = 100)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{d}{An \code{\link{integer}} giving the degree of the polynomial. Must be less
than the number of unique points.}

\item{tolerance}{A \code{\link{numeric}} scalar giving the tolerance of difference
between iterations.}

\item{stop}{An \code{\link{integer}} giving the stopping rule (i.e. maximum number of
iterations).}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Polynomial Baseline Estimation
}
\examples{
## X-ray diffraction
data("XRD")

## Subset from 20 to 70 degrees
XRD <- signal_select(XRD, from = 20, to = 70)

## Plot spectrum
plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")

## Polynomial baseline
baseline <- baseline_polynomial(XRD, d = 4, tolerance = 0.02, stop = 1000)

plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")
lines(baseline, type = "l", col = "red")
}
\references{
Lieber, C. A. and Mahadevan-Jansen, A. (2003). Automated Method for
Subtraction of Fluorescence from Biological Raman Spectra. \emph{Applied
Spectroscopy}, 57(11): 1363-67. \doi{10.1366/000370203322554518}.
}
\seealso{
\code{\link[=signal_correct]{signal_correct()}}

Other baseline estimation methods: 
\code{\link{baseline_linear}()},
\code{\link{baseline_peakfilling}()},
\code{\link{baseline_rollingball}()},
\code{\link{baseline_rubberband}()},
\code{\link{baseline_snip}()}
}
\author{
N. Frerebeau
}
\concept{baseline estimation methods}
