% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topology.R
\name{tableEdges}
\alias{tableEdges}
\title{Tabulate the number of edges between annotations within a lineage tree}
\usage{
tableEdges(graph, field, indirect = FALSE, exclude = NULL)
}
\arguments{
\item{graph}{igraph object containing an annotated lineage tree.}

\item{field}{string defining the annotation field to count.}

\item{indirect}{if \code{FALSE} count direct connections (edges) only. If 
\code{TRUE} walk through any nodes with annotations specified in 
the \code{argument} to count indirect connections. Specifying
\code{indirect=TRUE} with \code{exclude=NULL} will have no effect.}

\item{exclude}{vector of strings defining \code{field} values to exclude from counts.
Edges that either start or end with the specified annotations will not
be counted. If \code{NULL} count all edges.}
}
\value{
A data.frame defining total annotation connections in the tree with columns:
          \itemize{
            \item  \code{PARENT}:  parent annotation
            \item  \code{CHILD}:   child annotation
            \item  \code{COUNT}:   count of edges for the parent-child relationship
          }
}
\description{
\code{tableEdges} creates a table of the total number of connections (edges) for each 
unique pair of annotations within a tree over all nodes.
}
\examples{
# Define example graph
graph <- ExampleTrees[[23]]

# Count direct edges between isotypes including inferred nodes
tableEdges(graph, "ISOTYPE")

# Count direct edges excluding edges to and from germline and inferred nodes
tableEdges(graph, "ISOTYPE", exclude=c("Germline", NA))

# Count indirect edges walking through germline and inferred nodes
tableEdges(graph, "ISOTYPE", indirect=TRUE, exclude=c("Germline", NA))

}
\seealso{
See \link{testEdges} for performed a permutation test on edge relationships.
}

