% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statPrint.R
\name{statPrint}
\alias{statPrint}
\title{Descriptive (Change) statistics and plots}
\usage{
statPrint(clustr, traj, id_field = TRUE, bandw = 0.25,
  type = "lines", y.scaling = "fixed")
}
\arguments{
\item{clustr}{[vector (charater)] A vector of cluster membership (labels). For instance, the result extracted from the \code{\link{akmedoids.clust}} function.}

\item{traj}{[matrix (numeric)]: corresponding longitudinal data used to generate \code{clustr} (with rows corresponding to each label of \code{clustr}). For example, the first label of \code{clustr} is the group label of the first row of \code{traj} matrix, and so on.}

\item{id_field}{[numeric or character] Whether the first column of the \code{traj} is a unique (\code{id}) field. Default: \code{FALSE}. If \code{TRUE} the function recognises the second column as the first time step.}

\item{bandw}{[numeric] A small probability (quantile) value between \code{[0,1]} to partition the trajectories into three classes, i.e. \code{lower}, \code{central}, and the \code{uppper} classes. The middle of the \code{central} class is defined by the average slope of all trajectories. The upper and the lower limits of the \code{central} class is determined by the value of \code{bandw}. Default value is \code{0.25}, indicating that all slopes within 25th quantiles of the maximum slopes on both sides of the average slope are categorised as \code{central} class.}

\item{type}{[character] plot type. Available options are: \code{"lines"} and \code{"stacked"}.}

\item{y.scaling}{[character] works only if \code{type="lines"}. \code{y.scaling} set the vertical scales of the cluster panels. Options are: \code{"fixed"}: uses uniform scale for all panels, \code{"free"}: uses variable scales for panels.}
}
\value{
A plot showing group membership or sizes (proportion) and statistics.
}
\description{
This function perform two tasks: (i) it generate the descriptive and change statistics of groups, particularly suited for the outputs form the \code{\link{akmedoids.clust}} function, and (ii) generates the plots of the groups (performances).
}
\details{
Generates the descriptive and change statistics of the trajectory groupings. Given a vector of group membership (labels) and the corresponding data matrix (or data.frame) indexed in the same order, this function generates all the descriptive and change statistics of all the groups.
The function can generate a line and an area stacked plot drawing from the functionalities of the \code{ggplot2} library. For a more customised visualisation, we recommend that users deploy \code{ggplot2} directly (\code{Wickham H. (2016)}).
}
\examples{
print(traj)
traj <- dataImputation(traj, id_field = TRUE, method = 1, replace_with = 1,
fill_zeros = FALSE)
print(traj)
traj <- props(traj, id_field = TRUE)
clustr <- akmedoids.clust(traj, id_field = TRUE, method = "linear", k = c(3,6))
clustr <- as.vector(clustr$optimSolution)
print(statPrint(clustr, traj, id_field=TRUE, type="lines", y.scaling="fixed"))
print(statPrint(clustr, traj, id_field=TRUE, bandw = 0.30, type="stacked"))
}
\references{
\code{Wickham H. (2016). Elegant graphics for Data Analysis. Spring-Verlag New York (2016)}
}
\keyword{clusters}
\keyword{plot,}
