% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_station_data.R
\name{get_station_single_month}
\alias{get_station_single_month}
\title{Download monthly pollution data}
\usage{
get_station_single_month(pollutant, year, month)
}
\arguments{
\item{pollutant}{The type of pollutant to download.
\itemize{
 \item{"SO2"}{ - Dioxido de azufre (partes por billon)}
 \item{"CO"}{ - Monoxido de carbono (partes por millon)}
 \item{"NOX"}{ - Oxidos de nitrogeno (partes por billon)}
 \item{"NO2"}{ - Dioxido de nitrogeno (partes por billon)}
 \item{"NO"}{ - Oxido nitrico (partes por billon)}
 \item{"O3"}{ - Ozono (partes por billon)}
 \item{"PM10"}{ - Particulas menores a 10 micrometros (microgramos por metro cubico)}
 \item{"PM25"}{ - Particulas menores a 2.5 micrometros (microgramos por metro cubico)}
 \item{"WSP"}{ - Velocidad del viento (metros por segundo)}
 \item{"WDR"}{ - Direccion del viento (grados)}
 \item{"TMP"}{ - Temperatura ambiente (grados Celsius)}
 \item{"RH"}{ - Humedad relativa (porcentaje)}
}}

\item{year}{a numeric vector containing the years for which to download data (the earliest possible value is 1986)}

\item{month}{month number to download}
}
\value{
a data.frame with pollution data, when downloading "HORARIOS" the hours correspond the
GMT+6 timezone
}
\description{
retrieve hourly averages of pollution data by station from the air quality server at \url{
http://www.aire.cdmx.gob.mx/estadisticas-consultas/concentraciones/index.php}
}
\examples{
\dontrun{
## Download daily hourly PM10 data (particulate matter 10 micrometers or less in diameter)
## from March 2016
df_pm10 <- get_station_single_month("PM10", 2016, 3)
head(df_pm10)
df_o3 <- get_station_single_month("O3", 2017, 10)
head(df_o3)
}
}
